/* @TITLE "obl: OPRA - Offline PRefetch Analyzer" */
/* 
 * obl - One-Block-Lookahead
 * 
 * David Kotz 1989
 *
 * This algorithm decides to prefetch i+1 whenever it sees access to
 * block i.
 * 
 * Immediate rereference counts as a correct prediction.
 * 
 */

#include <stdio.h>
#include "dfk.h"
#include "opra.h"

static int last;

void
ResetOBL()
{
    last = -100;
}

boolean
RefOBL(block, mistake)
	int block;
	int *mistake;
{
    if (block != last && block != last+1) {
	   *mistake = (last >= 0) ? 1 : 0;
	   last = block;
	   return(FALSE);
    } else {
	   *mistake = 0;
	   last = block;
	   return(TRUE);
    }
}

void
LastOBL(mistake)
	int *mistake; 
{
    *mistake = (last >= 0) ? 1 : 0;
}


