/*
 * queuestack - A queue and a stack handler
 * 
 * David Kotz      January 1989, February 1990
 * 
 * The elements on the queue are int's. 
 * The queue or stack is of fixed size - they can overflow.
 *
 * Requires dfk.h to be included previously.
 */

typedef int qs_error;
#define QS_OK	 	((qs_error)0)
#define QS_OVERFLOW	((qs_error)1)
#define QS_EMPTY	((qs_error)2)

typedef struct queue_s QUEUE;	/* Queue handle */
extern QUEUE *MakeQueue();	/* (size) */
extern qs_error Enqueue();	/* (queue, item) */
extern qs_error Dequeue();	/* (queue, *item) */
extern qs_error Peekqueue();	/* (queue, index, *item) */
extern int Inqueue();		/* (queue) -> number in queue */
extern boolean Emptyqueue();	/* (queue) -> TRUE if queue is empty */

typedef struct stack_s STACK;	/* Stack handle */
extern STACK *MakeStack();	/* size */
extern qs_error PushStack();	/* (stack, item) */
extern qs_error PopStack();	/* (stack, *item) */
