/* @TITLE "verify: verify a file" */
/*
 *  verify - take a set of DISK files and check the data.
 *  The disk layout must have been CONTIGUOUS.
 *
 * Part of 
 *           The STARFISH Parallel file-system simulator
 *      (Simulation Tool for Advanced Research in File Systems)
 *
 *                              David Kotz
 *                          Dartmouth College
 *                             Version 3.0
 *                             October 1996
 *                         dfk@cs.dartmouth.edu
 */

#include <stdio.h>
#include <stdlib.h>
#include "dmcache.h"
#include "file.h"
#include "diskmodel.param"

#ifndef LAYOUT_CONTIGUOUS
hey! Should be LAYOUT-CONTIGUOUS !!!
#endif

boolean CheckBuf(char *p, int nbytes);

int
main(int argc, char **argv)
{
    int disk;
    char buf[BLOCK_SIZE];
    int block;
    char diskname[10];
    FILE *diskfp[NO_OF_DISKS];

    /* open all the files */
    for (disk = 0; disk < NO_OF_DISKS; disk++) {
	sprintf(diskname, "DISK%02d", disk);
	diskfp[disk] = fopen(diskname, "r");
	if (diskfp[disk] == (FILE *)NULL) {
	    fprintf(stderr, "Cannot open file '%s'\n", diskname);
	    exit(1);
	}
    }

    /* read each file block in turn, and print it out */
    for (disk = 0, block = 0; block < FILE_BLOCKS; 
	 block++, disk = (disk+1) % NO_OF_DISKS) {
	if (fread(buf, BLOCK_SIZE, 1, diskfp[disk]) != 1) {
	    fprintf(stderr, "Error reading block %d from disk %d\n", 
		    block, disk);
	    exit(1);
	}
	if (!CheckBuf(buf, BLOCK_SIZE)) {
	    printf("Incorrect data in block %d, disk %d, diskblock %d\n", 
		    block, disk, block / NO_OF_DISKS);
	}
    }

    fprintf(stderr, "%d blocks verified\n", block);

    return(0);
}


boolean
CheckBuf(char *p, int nbytes)
{
    while (nbytes-- > 0)
      if (*p++ != 'X')
	return(FALSE);

    return(TRUE);
}
