/* @TITLE "userdebug.c: debugging functions"*/
/* 
 * Debugging functions defined here:
 * functions:
 *    UserDebug - can be called from Proteus snapshot mode
 *
 * Part of 
 *           The STARFISH Parallel file-system simulator
 *      (Simulation Tool for Advanced Research in File Systems)
 *
 *                              David Kotz
 *                          Dartmouth College
 *                             Version 3.0
 *                             October 1996
 *                         dfk@cs.dartmouth.edu
 */

static char rcsid[] = "$Id: userdebug.c,v 3.0 1996/10/18 06:05:51 dfk RELEASE3 dfk $";

#include "dmcache.h"		/* the overall include file */

extern void FSdebug();		/* in cpfs-*.ca */
extern void IOPdebug();		/* in iopfs-*.ca */

/* @SUBTITLE "UserDebug: menu of debug calls" */
/* just calls some other specific debugging procedure of mine */
void
UserDebug(void)
{
    char option[100];

    while(TRUE) {
	printf("\nDMCACHE UserDebug.\n rcsid = %s\n\n", rcsid);
	printf("Options:\n");
	printf("cp\t\tFSdebug()\n");
	printf("iop\t\tIOPdebug()\n");
	printf("quit\t\tquit UserDebug\n");
	printf("\nOption: ");
	scanf("%s", option);
	   
	if (strcmp(option, "cp") == 0)
	  FSdebug();
	else if (strcmp(option, "iop") == 0)
	  IOPdebug();
	else if (strcmp(option, "quit") == 0)
	  return;
	else 
	  printf("Unrecognized option '%s'\n", option);
    }
}
