/* @TITLE "user-events.h: DMCACHE event types" */
/*
 * This is in addition to events.h. 
 * 
 * Part of 
 *           The STARFISH Parallel file-system simulator
 *      (Simulation Tool for Advanced Research in File Systems)
 *
 *                              David Kotz
 *                          Dartmouth College
 *                             Version 3.0
 *                             October 1996
 *                         dfk@cs.dartmouth.edu
 */
/* $Id: user-events.h,v 3.0 1996/10/18 06:05:51 dfk RELEASE3 dfk $ */

#ifndef USER_EVENTS_H
# define USER_EVENTS_H

/***************************************************************************
    Long-format event types (high bit is 0)
        Format: first long word:  8-bit event code, 24-bit index
	        second long word: 32-bit data field
		third long word:  32-bit timestamp
***************************************************************************/
/* for these, I will use things starting with 1-7 */

/***************************************************************************
    Short-format event types (high bit is 1)
        Format: first long word:  8-bit event code, 10-bit index, 14-bit data
	        second long word:  32-bit timestamp
***************************************************************************/
/* for these, I will use things starting with a-f */


/* in diskdevice.c, tracking disk operations */
/* events must be sorted for these to make sense */
#define EV_DISKREAD 	      0x10000000 /* index=disknum, data=sector */
#define EV_DISKWRITE	      0x11000000 /* index=disknum, data=sector */
#define EV_DISKPREREAD	      0x12000000 /* index=disknum, data=sector */

#define EV_DISKIDLE 		0xa1000000 /* index=disknum, data=0 */
#define EV_DISKBUSY 		0xa2000000 /* index=disknum, data=0 */
#define EV_DISKSTATE 		0xa3000000 /* index=disknum, data=state */
#define EV_BUSSTATE 		0xa4000000 /* index=busnum, data=state */
#define EV_BUSCONTEND 		0xa5000000 /* index=busnum, data=numUsers */

/* in iopfs-*.ca, tracking operations */
#define EV_BLOCKREAD 		0x20000000 /* index=disk, data=block */
#define EV_BLOCKWRITE 		0x21000000 /* index=disk, data=block */
#define EV_IOPREAD 	 	0x22000000 /* index=disk, data=block */
#define EV_IOPWRITE	 	0x23000000 /* index=disk, data=block */
#define EV_AHEAD    		0x24000000 /* index=disk, data=block */
#define EV_BEHIND    		0x25000000 /* index=disk, data=block */
#define EV_WRITEBACK   		0x26000000 /* index=disk, data=block */
#define EV_FILLBLOCK   		0x27000000 /* index=disk, data=block */
#define EV_EMPTYBLOCK  		0x28000000 /* index=disk, data=block */

#define EV_IOPREAD_LW 	      0xb0000000 /* index=0, data=0 */
#define EV_IOPWRITE_LW1	      0xb1000000 /* index=0, data=0 */
#define EV_IOPREAD_SEG 	      0xb2000000 /* index=0, data=0 */
#define EV_IOPWRITE_SEG	      0xb3000000 /* index=0, data=0 */
#define EV_IOPREAD_GEN 	      0xb4000000 /* index=0, data=Pattern */
#define EV_IOPWRITE_GEN	      0xb5000000 /* index=0, data=Pattern */
#define EV_IOPFLUSH	      0xb6000000 /* index=0, data=Pattern */

/* In cpfs-*.ca, tracking operations */
#define EV_FSFETCH  	      0x30000000 /* index=procnum, data=block */
#define EV_FSWRITEBACK        0x31000000 /* index=procnum, data=block */
#define EV_FSPREFETCH         0x32000000 /* index=procnum, data=block */

#define EV_FSREAD 	    	0xc0000000 /* index=procnum, data=bytes */
#define EV_FSWRITE	 	0xc1000000 /* index=procnum, data=bytes */
#define EV_FSREAD_LW		0xc2000000 /* index=procnum, data=0 */
#define EV_FSWRITE_LW1		0xc3000000 /* index=procnum, data=0 */
#define EV_FSREAD_SEG		0xc4000000 /* index=procnum, data=0 */
#define EV_FSWRITE_SEG		0xc5000000 /* index=procnum, data=0 */
#define EV_FSREAD_GEN		0xc6000000 /* index=procnum, data=Pattern */
#define EV_FSWRITE_GEN		0xc7000000 /* index=procnum, data=Pattern */
#define EV_FSFLUSH		0xc8000000 /* index=procnum, data=0 */

/* in message.h, tracking message sends and receives */
#define EV_THREADREQUEST_S	0xd0000000
#define EV_THREADREQUEST_E	0xd1000000
#define EV_REPLY_S	 	0xd2000000
#define EV_REPLY_E	 	0xd3000000
#define EV_INSTREQUEST_S	0xd4000000
#define EV_INSTREQUEST_E	0xd5000000
#define EV_MEMPUT_S		0xd6000000
#define EV_MEMPUT_E		0xd7000000
#define EV_MEMGET		0xd8000000
#define EV_QUEUEREQUEST_S	0xd9000000
#define EV_QUEUEREQUEST_E	0xda000000

#endif /* USER_EVENTS_H */


