/* @TITLE "time.h: Definitions about time"*/
/* 
 * Functions and constants about time.
 * types:
 *   TICS
 * constants:
 *   TICSperMSEC
 *   SECperTIC
 *   MSECperTIC
 * macros:
 *   GetTime
 *   DiffTime
 *
 * Part of 
 *           The STARFISH Parallel file-system simulator
 *      (Simulation Tool for Advanced Research in File Systems)
 *
 *                              David Kotz
 *                          Dartmouth College
 *                             Version 3.0
 *                             October 1996
 *                         dfk@cs.dartmouth.edu
 */

/* $Id: time.h,v 3.0 1996/10/18 06:05:51 dfk RELEASE3 dfk $ */

#ifndef TIME_H
#define TIME_H

#include "dfk.h"	      /* get the basic types */
#include "proteus.h"	      /* get the basic types */

typedef Time TICS;	      /* where Time is a Proteus definition */

#ifdef LONG_LONG_TIME
# define MAXTIME (TICS)(0xffffffffffffffffLL)
#else
# define MAXTIME (TICS)(0xffffffffL)
#endif
#define NEVER MAXTIME

/* TICSperSEC is in dmcache.h */
#define TICSperMSEC (TICSperSEC / 1000)

#define SECperTIC (1.0/TICSperSEC)
#define MSECperTIC (SECperTIC * 1000.)

#define GetTime() (TICS)(CURRENTTIME)

/* difference between a (later) and b (sooner) */
/* if a is before b, the difference is defined as 0 */
#define DiffTime(a,b) (TICS)(((a) > (b)) ? (a)-(b) : 0)

/* ******************************************************** */
/* For simple start/end time measurements within a function */
#define ELAPSED_DEFS TICS starttime, elapsedtime
#define START_CLOCK { \
   CYCLE_COUNTING_OFF; \
   starttime = GetTime(); \
   CYCLE_COUNTING_ON; \
}
#define STOP_CLOCK { \
   CYCLE_COUNTING_OFF; \
   elapsedtime = DiffTime(GetTime(), starttime); \
   CYCLE_COUNTING_ON; \
}
#define ELAPSED_TICS elapsedtime
#define ELAPSED_MSEC (elapsedtime * MSECperTIC)
#define ELAPSED_SEC (elapsedtime * SECperTIC)

#endif /* TIME_H */
