# a nawk script
# caller should set variable "type" on command line

# Part of
#              The STARFISH Parallel file-system simulator
#        (Simulation Tool for Advanced Research in File Systems)
# 
#                               David Kotz
#                           Dartmouth College
#                              Version 3.0
#                              January 1996
#                          dfk@cs.dartmouth.edu
#

#   1      2     3       4        5             6
# Pattern CPFS IOPFS DISK_SORT RECORD_SIZE DISK_LAYOUT 
#  7              8      9    10     11         12     13
# FILE_BLOCKS BLOCK_SIZE Nio Ncomp NO_OF_DISKS total tthruput

function initnames()
{
    i = 0;

    patname[i++] =     "nullcommtest";
    patname[i++] =     "datacommtest";
    patname[i++] =     "memgettest";
    patname[i++] =     "copytest";
    patname[i++] =     "disktest";

    # plain patterns 
    patname[i++] =     "rrlw";
    patname[i++] =     "rrlps";
    patname[i++] =     "brlw";
    patname[i++] =     "rwlw";
    patname[i++] =     "bwlw";
    patname[i++] =     "wrlw";
    patname[i++] =     "wrlw1";
    patname[i++] =     "wwlw1";
    patname[i++] =     "wrseg";
    patname[i++] =     "wwseg";

    # Read, 1-D distributions 
    patname[i++] =     "wrn";
    patname[i++] =     "wrb";
    patname[i++] =     "wrc";

    # Read, 2-D DISTRIBUTION(NONE, ...) 
    patname[i++] =     "wrnn";
    patname[i++] =     "wrnb";
    patname[i++] =     "wrnc";

    # Read, 2-D DISTRIBUTION(BLOCK, ...) 
    patname[i++] =     "wrbn";
    patname[i++] =     "wrbb";
    patname[i++] =     "wrbc";

    # Read, 2-D DISTRIBUTION(CYCLIC, ...) 
    patname[i++] =     "wrcn";
    patname[i++] =     "wrcb";
    patname[i++] =     "wrcc";

    # Write, 1-D distributions 
    patname[i++] =     "wwn";
    patname[i++] =     "wwb";
    patname[i++] =     "wwc";

    # Write, 2-D DISTRIBUTION(NONE, ...) 
    patname[i++] =     "wwnn";
    patname[i++] =     "wwnb";
    patname[i++] =     "wwnc";

    # Write, 2-D DISTRIBUTION(BLOCK, ...) 
    patname[i++] =     "wwbn";
    patname[i++] =     "wwbb";
    patname[i++] =     "wwbc";

    # Write, 2-D DISTRIBUTION(CYCLIC, ...) 
    patname[i++] =     "wwcn";
    patname[i++] =     "wwcb";
    patname[i++] =     "wwcc";

    sortname[0] = "nosort";
    sortname[1] = "sort";

    i = 0;
    cpfsname[i++] = "none";
    cpfsname[i++] = "single";
    cpfsname[i++] = "double";
    cpfsname[i++] = "thread";
    cpfsname[i++] = "direct";

    i = 0;
    iopfsname[i++] = "none";
    iopfsname[i++] = "buffer";
    iopfsname[i++] = "cache";
    iopfsname[i++] = "direct";
    iopfsname[i++] = "general";

    layoutname[0] = "contig";
    layoutname[1] = "rsectors";
    layoutname[2] = "rtracks";
}


BEGIN {
  initnames();
  maxfile = "/tmp/dobar/max"
  datafile = "/tmp/dobar/data"
  plotfile = "/tmp/dobar/plot"
  yval = 0;
  xmax = 0;
  xmin = 0;
#  print "set nokey" >> plotfile;
  print "set noytics" >> plotfile;
  print "set data style lines" >> plotfile;
#  print "set grid" >> plotfile;
  print "set ylabel 'configuration'" >> plotfile;
  if (type == "data" || type == "avg") 
    print "set xlabel 'KB/s'" >> plotfile;
  else
    print "set xlabel 'percent improvement'" >> plotfile;
}

# for every input line
{
  config = patname[$1] " " $9 "." $10 "." $11 "." $5 "." layoutname[$6];
  label = config "." iopfsname[$3] "." sortname[$4];
  datafilename = datafile "." iopfsname[$3] "." sortname[$4];
  systems[iopfsname[$3] "." sortname[$4]] = 1;

  if (config != lastconfig)
    yval++;			# skip a line

  x = $13;
  if (patname[$1] == "wrlw") x /= $10; # scale down by ncomp

  print 0, yval > datafilename;
  print x, yval > datafilename;
  print "" > datafilename;

  base = config ".cache.nosort";
  if (type == "avg" || type == "data") {
    if (base != label && base in y) {
      improvement = x / y[base];
#      improvement = (x - y[base]) / y[base] * 100.;
      printf "set label ' %s %.3fx' at %g,%g left\n", \
	label, improvement, x, yval >> plotfile;
    } else {
      y[base] = x;
      printf "set label ' %s' at %g,%g left\n", label, x, yval >> plotfile;
    }
  } else {
    printf "set label ' %s %.1f%%' at %g,%g left\n", \
      label, x, x, yval >> plotfile;
  }

  yval++;
  if (x > xmax) xmax = x;
  if (x < xmin) xmin = x;
  lastconfig = config;

# for use in END below
  ndisks = $11; # assumes that this stays constant
  ncomp = $10;	# assumes that this stays constant
  pat = $1;	# assumes that this stays constant
}

END {
  print "set yrange [0:" yval+1 "]" >> plotfile;

  if (type == "data" || type == "avg") {
    maxbw = ndisks * 4002. / 60 * 512 / 1024 * 72;
    if (patname[pat] == "wrlw") maxbw *= ncomp;
    print maxbw, 0 > maxfile;
    print maxbw, yval+1 > maxfile;
    print "set xrange [" 0 ":" maxbw*2 "]" >> plotfile;
    domax = 1;
  } else {			# type == imp || type == avgimp
    print "set xrange [" xmin ":" xmax*2 "]" >> plotfile;
  }

  print "plot \\" >> plotfile;
  first = 1;
  for (sys in systems) {
      if (first) first = 0;
      else print ", \\" >> plotfile;
      print "\"" datafile "." sys "\" title \"" sys "\" \\" >> plotfile;
  }

  if (domax)
    print ", \"" maxfile "\" notitle" >> plotfile;
  else
    print "" >> plotfile;
}
