/* @TITLE "queue.h: queue data structure"*/
/* 
 * queue: this is a normal FIFO queue module, with a fixed maximum capacity.
 *
 * Part of 
 *           The STARFISH Parallel file-system simulator
 *      (Simulation Tool for Advanced Research in File Systems)
 *
 *                              David Kotz
 *                          Dartmouth College
 *                             Version 3.0
 *                             October 1996
 *                         dfk@cs.dartmouth.edu
 */

/* $Id: queue.h,v 3.0 1996/10/18 06:05:51 dfk RELEASE3 dfk $ */

#ifndef QUEUE_H
#define QUEUE_H

typedef void *Qitem;          /* a queue item is any pointer */

/* ******************************************************* */
/* CYCLE-COUNTED versions (only usable in USER mode) */
typedef struct queue_s QUEUE; /* Queue handle */

extern QUEUE *MakeQueue(int size, char *debugname); /* make a new queue */
extern void Enqueue(QUEUE *q, Qitem item);
extern void Dequeue(QUEUE *q, Qitem *item);
extern int InQueue(QUEUE *q); /* number currently in queue */
extern boolean EmptyQueue(QUEUE *q); /* TRUE if queue is empty */
extern void FreeQueue(QUEUE *q); /* destroy a queue */

/* ******************************************************* */
/* NON-CYCLE-COUNTED versions (also useful in ENGINE mode) */
typedef struct queue_noncyc_s NCQUEUE; /* Queue handle */

extern NCQUEUE *MakeQueue_noncyc(int size, char *debugname); /* new queue */
extern void Enqueue_noncyc(NCQUEUE *q, Qitem item);
extern void Dequeue_noncyc(NCQUEUE *q, Qitem *item);
extern int InQueue_noncyc(NCQUEUE *q); /* number currently in queue */
extern boolean EmptyQueue_noncyc(NCQUEUE *q); /* TRUE if queue is empty */
extern void FreeQueue_noncyc(NCQUEUE *q); /* destroy a queue */

#endif QUEUE_H
