/* @TITLE "broadcast.h: interface for broadcast" */
/*
 * broadcast - interface to broadcast message-passing functions
 * ANSI C
 *
 * This defines a family of broadcast functions that 
 * accept a fixed number of arguments, including the 
 * function to call. The handler, though, is independent of the
 * number of arguments, using a switch statement to call the function 
 * with the right number of arguments. This may be dependent on the 
 * way the C compiler handles arguments.  Doesn't seem to work for floats
 * and doubles, even if you count them as two Words each.
 * 
 * BroadcastV is a broadcast function that takes an arbitrary
 * data block to broadcast, but the first word must contain a
 * pointer to the function to call.
 *
 * Part of 
 *           The STARFISH Parallel file-system simulator
 *      (Simulation Tool for Advanced Research in File Systems)
 *
 *                              David Kotz
 *                          Dartmouth College
 *                             Version 3.0
 *                             October 1996
 *                         dfk@cs.dartmouth.edu
 *
 * $Id: broadcast.h,v 3.0 1996/10/18 06:05:51 dfk RELEASE3 dfk $
 */

#ifndef BROADCAST_H
#define BROADCAST_H

#include "dmcache.h"	      /* get the basic types */

/* Called once to initialize the data structures.
 * You can call it again (while there is no active broadcast)
 * to reset the value of nprocs. Procs [0..nprocs) participate.
 */
extern void broadcast_init(int nprocs);

/* Broadcast a function call to all processors */
/* The first parameter is a function pointer; the others are words. */
extern void broadcast0();	/* (f); */
extern void broadcast1();	/* (f, a1); */
extern void broadcast2();	/* (f, a1, a2); */
extern void broadcast3();	/* (f, a1, a2, a3); */
extern void broadcast4();	/* (f, a1, a2, a3, a4); */
extern void broadcast5();	/* (f, a1, a2, a3, a4, a5); */

/* Broadcast a function call to all processors.
 * Notice this does not have form (f, argc, argv) as you might expect;
 * the function f is part of the argv, in the first word.
 * This function f is called with the same (len, data).
 * Here, the data is typically a structure pointer, for a structure
 * whose first element is the function pointer, and the rest are 
 * arbitrary data (including floats, structs, unions, etc). 
 */
extern void broadcastV(int len, Word *data);  /* first word is a FuncPtr */

#endif /* BROADCAST_H */
