 /**************************************************************************\
 * simex.c, part of simex
 *
 *  David Kotz, 1996
 *
 *  simex is a stripped-down version of stats, in which I tossed all 
 * of the GUI and graph-making stuff.  It's just enough to read events.sim
 * and print out the metrics. 
 *
 * DERIVED FROM
 *    stats.h, part of stats
 *    by Eric A. Brewer  and  Chris N. Dellarocas, 1991
 **************************************************************************/

#include <assert.h>

#define GLOBAL
#define LIBRARY extern
#define MAXINT 0x7fffffff

#ifndef __STDC__  /* remove const keyword, not implemented in DEC cc2.1 */
#define const
#endif

/* warning: min and max evaluate x, y multiple times */
#define MIN(x,y)           ( ((x)<(y)) ? (x) : (y))
#define MAX(x,y)           ( ((x)>(y)) ? (x) : (y))

typedef unsigned long ulong;
typedef long Word;
typedef ulong Time;

typedef short BOOL;
#define TRUE 1
#define FALSE 0

#define MAX_POINTS 500000
#define MAX_VIEWS 10
#define MAX_TABLES 100
#define MAX_GRAPHS 125
#define MAX_LINE_SIZE 1000
#define MAX_METRICS 256
#define MAX_AMETRICS 256

typedef enum {STEP_GRAPH, COLOR_GRAPH, SET_GRAPH, METRICS_GRAPH,
		METRICS_TABLE, AMETRICS_GRAPH, AMETRICS_TABLE,
		BAR_GRAPH, BAR_TABLE, MRUN_GRAPH} kind;

typedef struct {
    float x, y;
} Point;

struct gT;

typedef struct nodeStruct {
        short typ;
        union {
            struct nodeStruct *l;
            float f;
	    long i;
            char *s;
	    struct gT *g;
        } v;
        struct nodeStruct *r;
} nodeType;

typedef struct stL {
    char *string;
    struct stL *next;
} strList;

typedef struct nmT {
    char *name;
    float value;
    struct nmT *next;
} nameType;

typedef struct {
    char *name;
    float value;
} metricType;
extern metricType *metrics, *the_metrics[MAX_TABLES];

typedef struct {
    char *name;
    int size;
    float *value;
} ametricType;
extern ametricType *ametrics, *the_ametrics[MAX_TABLES];

extern char **proc_names;
extern const char *files[];


/**********************  global variables *************************/

/* allocated in simex.c */
extern float version_number;
extern char *date_string, version_string[40];
extern char *event_filename;
extern char *types_filename;
extern char *usertypes_filename;
extern BOOL display_trace;
extern BOOL debug;
extern BOOL is_sorted;
extern BOOL verbose;
extern BOOL byte_reverse;
extern BOOL all_metrics;

extern ulong *events, num_events;
extern char *simulation_title;
extern int current_hash_table;
extern ulong event_list_size;


#define METRICS_SPACING  40
#define ROW_SPACING      24
#define COL_SPACING     250

/* profile metrics */
#define NUMCALLS_METRIC 251
#define PROF_METRIC     250

/* token types */
#define PARAM	300
#define METRIC	301
#define AMETRIC	302
#define EVT	303
#define ACT	304
#define NUM	305

#define SETFILE(sf) { current_hash_table = sf; \
		     metrics = the_metrics[current_hash_table]; \
		     ametrics = the_ametrics[current_hash_table];}


#define UNREACHABLE() \
  fatal("At \"UNREACHABLE()\" in file \"%s\", line %d\n", __FILE__, __LINE__)

#ifdef __STDC__
void fatal(char *fmt, ...);
#else
void fatal();
#endif

void LoadEvents(char *fname, BOOL display);
void SortEvents(void);
extern void LoadReservedWords(void);
extern void LoadEventNames(void);
extern int LoadMetrics(const char *fname);
extern void LoadOnlyMetrics(const char *fname);
extern void LoadParams(const char *fname);

extern void PrintVersion(void);
extern void HandleArgs(int argc, char **argv);
extern void PrintSelectedMetrics(void);
extern void PrintAllScalarMetrics(void);
extern void PrintAllArrayMetrics(void);

