
/****************************************************************************
 *                                                                          *
 *                     Parallel Architecture Simulator                      *
 *                Eric A. Brewer  and  Chris N. Dellarocas                  *
 *                     Laboratory for Computer Science                      *
 *                  Massachusetts Institute of Technology                   *
 *                                                                          *
 * Module: sema.net.nc.c
 *                                                                          *
 * Description:                                                             *
 *                                                                          *
 * Last Modified: $Date: 92/03/31 16:48:27 $
 *
 * Global Functions:                                                        *
 *                                                                          *
 * Global Variables:                                                        *
 *                                                                          *
 ****************************************************************************
 *   Copyright 1991
 *   Eric A. Brewer  and  Chris N. Dellarocas
 *   Massachusetts Institute of Technology
 *
 *   Permission to use, copy, modify, and distribute this program
 *   for any purpose and without fee is hereby granted, provided
 *   that this copyright and permission notice appear on all copies
 *   and supporting documentation, the name of M.I.T. not be used
 *   in advertising or publicity pertaining to distribution of the
 *   program without specific prior permission, and notice be given
 *   in supporting documentation that copying and distribution is
 *   by permission of M.I.T.  M.I.T. makes no representations about
 *   the suitability of this software for any purpose.  It is pro-
 *   vided "as is" without express or implied warranty.
 ****************************************************************************
 * $Header: /psg/proteus/RCS/sema.febit.c,v 1.2 92/03/31 16:48:27 brewer Exp $
 * $Log:	sema.febit.c,v $
 * Revision 1.2  92/03/31  16:48:27  brewer
 * now uses Sem typedef (defined in prototypes.h)
 * shared memory calls now use void * addresses
 * 
 * Revision 1.1  92/02/11  13:56:17  brewer
 * Initial revision
 * 
 \**************************************************************************/


int sem_P(Sem addr) 
{
    SemBlk *sptr;
    Word sid = AddrToSid((char *)addr);
    
    if (InvalidSem(sid) || (sptr = &semaphore[sid])->state == S_FREE)
#ifdef FATAL
      fatal("sem_P failed: Invalid semaphore %d", sid);
#else
    return(ERROR);
#endif
    
    
#ifdef SEMDEBUG
    printf("SEM #%d (P%d) Will P on semaphore %d (%s) (tag = %d) time = %d\n",
	   currtid, processor_, sid, sptr->name, memtag[sid*LINE_SIZE],
	   CURRENTTIME);
#endif
    
    EVENT_SEM_P(sid, CURRENTTIME);
    
    sptr->threadswaiting++;
    
    Shared_Memory_Write((void *)addr, 0, BYTE | TESTTAG | SETTAG);
    
    sptr->threadswaiting--;
    
    EVENT_SEM_V(sid, CURRENTTIME);
    
#ifdef SEMDEBUG
    printf("SEM #%d (P%d) P on semaphore %d SUCCESSFUL (tag = %d)\n",
	   currtid, processor_, sid, memtag[sid*LINE_SIZE]);
#endif
    
    return(OK);
}


int sem_V(Sem addr) 
{
    SemBlk *sptr;
    Word sid = AddrToSid((char *)addr);
    
    if (InvalidSem(sid) || (sptr = &semaphore[sid])->state == S_FREE) {
#ifdef SEMDEBUG
	printf("Invalid semaphore %d sid = %d\n", addr, sid);
#endif
#ifdef FATAL
	fatal("sem_V failed: Invalid semaphore %d", sid);
#else
	return(ERROR);
#endif
	
    }
    
#ifdef SEMDEBUG
    printf("SEM #%d (P%d) Will V semaphore %d (%s)\n",
	   currtid, processor_, sid, sptr->name);
#endif
    
    (void)Shared_Memory_WriteTag((void *)addr, EMPTY, PREVIOUS | BYTE);
    
#ifdef SEMDEBUG
    printf("SEM #%d (P%d) V on semaphore %d SUCCESSFUL (tag = %d)\n",
	   currtid, processor_, sid, memtag[sid*LINE_SIZE]);
#endif
    
    return(OK);
}



