/*
  Macros for performance specification monitoring
  (Not a supported Proteus feature---under development.)
  Sharon E. Perl  21 Feb 1992

  These macros turn off cycle counting, call the corresponding monitoring
  procedure, and then turn cycle counting on. These should always be used
  instead of directly calling the monitoring procedures.
 */

#include "user.h"
#include "monitorswitch.h"

#ifdef MONITORING_ON
#define PSPEC_STARTOP(typ, instid)CYCLE_COUNTING_OFF; \
   pspec_startop(typ,instid); CYCLE_COUNTING_ON;

#define PSPEC_ENDOP(typ, instid)CYCLE_COUNTING_OFF; \
   pspec_endop(typ,instid); CYCLE_COUNTING_ON;

#define PSPEC_STARTTIMER(typ, instid)CYCLE_COUNTING_OFF; \
   pspec_starttimer(typ,instid); CYCLE_COUNTING_ON;

#define PSPEC_ENDTIMER(typ, instid)CYCLE_COUNTING_OFF; \
   pspec_endtimer(typ,instid); CYCLE_COUNTING_ON;

#define PSPEC_INCCOUNTER(typ, instid)CYCLE_COUNTING_OFF; \
   pspec_inccounter(spec,typ,instid); CYCLE_COUNTING_ON;

#define PSPEC_RECPARAM(typ, instid, value)CYCLE_COUNTING_OFF; \
   pspec_recparam(typ,instid,value); CYCLE_COUNTING_ON;

#define PSPEC_RECGLOBAL(typ, value)CYCLE_COUNTING_OFF; \
   pspec_recglobal(typ, value); CYCLE_COUNTING_ON;

#define PSPEC_ATTACHINST(spec, instid) CYCLE_COUNTING_OFF; \
   pspec_attachinst(spec,instid); CYCLE_COUNTING_ON;

#define PSPEC_DETACHINST(spec, instid) CYCLE_COUNTING_OFF; \
   pspec_detachinst(spec,instid); CYCLE_COUNTING_ON;

#else

#define PSPEC_STARTOP(typ, instid)

#define PSPEC_ENDOP(typ, instid)

#define PSPEC_STARTTIMER(typ, instid)

#define PSPEC_ENDTIMER(typ, instid)

#define PSPEC_INCCOUNTER(typ, instid)

#define PSPEC_RECPARAM(typ, instid, value)

#define PSPEC_RECGLOBAL(typ, value)

#define PSPEC_ATTACHINST(spec, instid) 

#define PSPEC_DETACHINST(spec, instid) 

#endif

