/* 
 * $Header: /psg/proteus/RCS/ctxsw.S,v 1.7 92/09/23 12:25:28 brewer Exp $
 * $Log:	ctxsw.S,v $
 * Revision 1.7  92/09/23  12:25:28  brewer
 * (changed name from ctxsw.s to ctxsw.S)
 * 
 * Revision 1.6  92/04/27  11:59:57  brewer
 * Added code to save/restore multiplication registers during
 * a full context switch.
 * 
 * Revision 1.5  92/04/14  15:11:09  brewer
 * Fixed bug in full_ctxsw that resulted from commenting out load/save
 * of registers 4 and 5
 * 
 * Revision 1.4  92/04/01  17:19:05  brewer
 * changed RCS comment string to " * "
 * 
 * Revision 1.3  92/02/13  15:41:40  brewer
 * edited character constant out of log message (for gcc)
 * 
 * Revision 1.2  92/02/12  16:50:57  brewer
 * change RCS comment char to " # "
 * 
 * Revision 1.1  92/02/11  16:07:21  brewer
 * Initial revision
 */

	.text	
	.globl full_ctxsw
	.globl stack_pointer
	.align	2
	.ent	full_ctxsw
	.set noat
full_ctxsw:
/*      Full Context Switch Routine
 *
 *      Called from C as:  (should not be called from C, use ctxsw instead)
 *     
 *      full_ctxsw(optr, nptr)
 *
 *      where optr (passed in $4) contains register save address of old process
 *            nptr (passed in $5) contains register save address of new process
 *
 *      Routine saves current value of all registers in area designated by $4
 *      and subsequently loads all registers from area designated by $5
 */

	/* SAVE STATE OF OLD PROCESS */

	/* Save scalar registers */

	sw	$31  ,   0($4)   /* mark this as a full context switch */

	sw	$2   ,   8($4)
	sw	$3   ,  12($4)
/*	sw	$4   ,  16($4)   Removed to improve performance, eab 4-14-92 */
/*	sw	$5   ,  20($4)   */
	sw	$6   ,  24($4)
	sw	$7   ,  28($4)
	sw	$8   ,  32($4)
	sw	$9   ,  36($4)
	sw	$10  ,  40($4)
	sw	$11  ,  44($4)
	sw	$12  ,  48($4)
	sw	$13  ,  52($4)
	sw	$14  ,  56($4)
	sw	$15  ,  60($4)
	sw	$16  ,  64($4)
	sw	$17  ,  68($4)
	sw	$18  ,  72($4)
	sw	$19  ,  76($4)
	sw	$20  ,  80($4)
	sw	$21  ,  84($4)
	sw	$22  ,  88($4)
	sw	$23  ,  92($4)
	sw	$24  ,  96($4)
	sw	$25  , 100($4)
/*
 *	sw	$26  , 104($4)
 *	sw	$27  , 108($4)
 *	sw	$28  , 112($4)
 */
	sw	$29  , 116($4)
	sw	$30  , 120($4)
	sw	$31  , 124($4)
	/* Save fp registers */
	swc1	$f0  , 128($4)
	swc1	$f1  , 132($4)
	swc1	$f2  , 136($4)
	swc1	$f3  , 140($4)
	swc1	$f4  , 144($4)
	swc1	$f5  , 148($4)
	swc1	$f6  , 152($4)
	swc1	$f7  , 156($4)
	swc1	$f8  , 160($4)
	swc1	$f9  , 164($4)
	swc1	$f10 , 168($4)
	swc1	$f11 , 172($4)
	swc1	$f12 , 176($4)
	swc1	$f13 , 180($4)
	swc1	$f14 , 184($4)
	swc1	$f15 , 188($4)
	swc1	$f16 , 192($4)
	swc1	$f17 , 196($4)
	swc1	$f18 , 200($4)
	swc1	$f19 , 204($4)
	swc1	$f20 , 208($4)
	swc1	$f21 , 212($4)
	swc1	$f22 , 216($4)
	swc1	$f23 , 220($4)
	swc1	$f24 , 224($4)
	swc1	$f25 , 228($4)
	swc1	$f26 , 232($4)
	swc1	$f27 , 236($4)
	swc1	$f28 , 240($4)
	swc1	$f29 , 244($4)
	swc1	$f30 , 248($4)
	swc1	$f31 , 252($4)
	/* Save fp control register */
	cfc1	$8   , $31
	sw	$8   , 256($4)

	/* save multiplication registers */
	mfhi	$8
	sw	$8   , 260($4)
	mflo	$8
	sw	$8   , 264($4)


/* RESTORE STATE OF NEW PROCESS */

	/* Restore fp control register */
	lw	$8   , 256($5)
	ctc1	$8   , $31
	/* Restore scalar registers */

	lw	$16  ,  64($5)
	lw	$17  ,  68($5)
	lw	$18  ,  72($5)
	lw	$19  ,  76($5)
	lw	$20  ,  80($5)
	lw	$21  ,  84($5)
	lw	$22  ,  88($5)
	lw	$23  ,  92($5)

	lw	$29  , 116($5)
	lw	$30  , 120($5)
	lw	$31  , 124($5)

	/* Restore fp registers */

	lwc1	$f20 , 208($5)
	lwc1	$f21 , 212($5)
	lwc1	$f22 , 216($5)
	lwc1	$f23 , 220($5)
	lwc1	$f24 , 224($5)
	lwc1	$f25 , 228($5)
	lwc1	$f26 , 232($5)
	lwc1	$f27 , 236($5)
	lwc1	$f28 , 240($5)
	lwc1	$f29 , 244($5)
	lwc1	$f30 , 248($5)
	lwc1	$f31 , 252($5)

	lw	$2   ,   0($5)    /* restore full-context? */
	bgtz    $2,  full_restore

	/* Continue execution of new process */
	j	$31

full_restore: 
	lw	$2   ,   8($5)
	lw	$3   ,  12($5)
/*	lw	$4   ,  16($5)   Removed to improve performance, eab 4-14-92 */
/*	lw	$5   ,  20($4)   */
	lw	$6   ,  24($5)
	lw	$7   ,  28($5)
	lw	$8   ,  32($5)
	lw	$9   ,  36($5)
	lw	$10  ,  40($5)
	lw	$11  ,  44($5)
	lw	$12  ,  48($5)
	lw	$13  ,  52($5)
	lw	$14  ,  56($5)
	lw	$15  ,  60($5)

	lw	$24  ,  96($5)
	lw	$25  , 100($5)

	/* Restore fp registers */
	lwc1	$f0  , 128($5)
	lwc1	$f1  , 132($5)
	lwc1	$f2  , 136($5)
	lwc1	$f3  , 140($5)
	lwc1	$f4  , 144($5)
	lwc1	$f5  , 148($5)
	lwc1	$f6  , 152($5)
	lwc1	$f7  , 156($5)
	lwc1	$f8  , 160($5)
	lwc1	$f9  , 164($5)
	lwc1	$f10 , 168($5)
	lwc1	$f11 , 172($5)
	lwc1	$f12 , 176($5)
	lwc1	$f13 , 180($5)
	lwc1	$f14 , 184($5)
	lwc1	$f15 , 188($5)
	lwc1	$f16 , 192($5)
	lwc1	$f17 , 196($5)
	lwc1	$f18 , 200($5)
	lwc1	$f19 , 204($5)

	/* restore muliplication registers */
	lw	$4   , 260($5)
	mthi	$4
	lw	$4   , 264($5)
	mtlo	$4

	/* Continue execution of new process */
	j	$31
	.end	full_ctxsw

/**************************************************************************/
/* small version of context switch, only valid if not called from
   SimQuantum */
	.globl ctxsw
	.align	2
	.ent	ctxsw
	.set noat
ctxsw:
/*      Context Switch Routine
 *
 *      Called from C as:
 *     
 *      ctxsw(optr, nptr)
 *
 *      where optr (passed in $4) contains register save address of old process
 *            nptr (passed in $5) contains register save address of new process
 *
 *      Routine saves current value of all registers in area designated by $4
 *      and subsequently loads all registers from area designated by $5
 */

	/* SAVE STATE OF OLD PROCESS */

	sw	$0   ,  0($4)    /* mark as partial context switch */

	/* Save scalar registers */
	sw	$16  ,  64($4)
	sw	$17  ,  68($4)
	sw	$18  ,  72($4)
	sw	$19  ,  76($4)
	sw	$20  ,  80($4)
	sw	$21  ,  84($4)
	sw	$22  ,  88($4)
	sw	$23  ,  92($4)

	sw	$29  , 116($4)
	sw	$30  , 120($4)
	sw	$31  , 124($4)

	/* Save fp registers */
	swc1	$f20 , 208($4)
	swc1	$f21 , 212($4)
	swc1	$f22 , 216($4)
	swc1	$f23 , 220($4)
	swc1	$f24 , 224($4)
	swc1	$f25 , 228($4)
	swc1	$f26 , 232($4)
	swc1	$f27 , 236($4)
	swc1	$f28 , 240($4)
	swc1	$f29 , 244($4)
	swc1	$f30 , 248($4)
	swc1	$f31 , 252($4)

	/* Save fp control register */
	cfc1	$8   , $31
	sw	$8   , 256($4)

/* RESTORE STATE OF NEW PROCESS */

	/* Restore fp control register */
	lw	$8   , 256($5)
	ctc1	$8   , $31
	/* Restore scalar registers */

	lw	$16  ,  64($5)
	lw	$17  ,  68($5)
	lw	$18  ,  72($5)
	lw	$19  ,  76($5)
	lw	$20  ,  80($5)
	lw	$21  ,  84($5)
	lw	$22  ,  88($5)
	lw	$23  ,  92($5)

	lw	$29  , 116($5)
	lw	$30  , 120($5)
	lw	$31  , 124($5)

	/* Restore fp registers */

	lwc1	$f20 , 208($5)
	lwc1	$f21 , 212($5)
	lwc1	$f22 , 216($5)
	lwc1	$f23 , 220($5)
	lwc1	$f24 , 224($5)
	lwc1	$f25 , 228($5)
	lwc1	$f26 , 232($5)
	lwc1	$f27 , 236($5)
	lwc1	$f28 , 240($5)
	lwc1	$f29 , 244($5)
	lwc1	$f30 , 248($5)
	lwc1	$f31 , 252($5)

	lw	$2   ,   0($5)    /* restore full-context? */
	bgtz    $2,  full_restore2

	/* Continue execution of new process */
	j	$31

full_restore2: 
	lw	$2   ,   8($5)
	lw	$3   ,  12($5)
/*	lw	$4   ,  16($5)   */
/*	lw	$5   ,  20($4)   */
	lw	$6   ,  24($5)
	lw	$7   ,  28($5)
	lw	$8   ,  32($5)
	lw	$9   ,  36($5)
	lw	$10  ,  40($5)
	lw	$11  ,  44($5)
	lw	$12  ,  48($5)
	lw	$13  ,  52($5)
	lw	$14  ,  56($5)
	lw	$15  ,  60($5)

	lw	$24  ,  96($5)
	lw	$25  , 100($5)

	/* Restore fp registers */
	lwc1	$f0  , 128($5)
	lwc1	$f1  , 132($5)
	lwc1	$f2  , 136($5)
	lwc1	$f3  , 140($5)
	lwc1	$f4  , 144($5)
	lwc1	$f5  , 148($5)
	lwc1	$f6  , 152($5)
	lwc1	$f7  , 156($5)
	lwc1	$f8  , 160($5)
	lwc1	$f9  , 164($5)
	lwc1	$f10 , 168($5)
	lwc1	$f11 , 172($5)
	lwc1	$f12 , 176($5)
	lwc1	$f13 , 180($5)
	lwc1	$f14 , 184($5)
	lwc1	$f15 , 188($5)
	lwc1	$f16 , 192($5)
	lwc1	$f17 , 196($5)
	lwc1	$f18 , 200($5)
	lwc1	$f19 , 204($5)

	/* restore muliplication registers */
	lw	$4   , 260($5)
	mthi	$4
	lw	$4   , 264($5)
	mtlo	$4

	/* Continue execution of new process */
	j	$31
	.end	ctxsw

/**************************************************************************/

	/* stack_pointer() */
	.align 2
	.ent stack_pointer
stack_pointer:
/* Stack_pointer simply returns the current value of the stack pointer */
	and	$2, $sp, $sp
	j	$31
	.end stack_pointer

