
#include "cprep.h"
#include <string.h>
#include "symtable.h"

extern int lineno;

void identifier_decl(Lex *lex)
{
    Symbol *iptr = newsymbol();
    
    iptr->text       = copy_string( lex->text );
    iptr->class      = TYPEDEF_FLAG ? ID_TYPEDEF : 
      (currdecl->components ? ID_COMPONENT : ID_VARIABLE);
    iptr->type       = currdecl->type;
#ifdef DEBUG
    printf("line %d:", lineno);
    print_type(iptr->type);
#endif
    iptr->attributes = currdecl->attributes;
    
    /*  
      if ( TYPEDEF_FLAG )
      iptr->type->backlink = iptr;
      */  
    lex->tinfo  = (Word)iptr;
}


void pointer_decl(Lex *star, Lex *rest)
{
    Type **p;
    Type *tptr = newtype();
    Symbol *iptr = (Symbol *)rest->tinfo;
    
    rest->text = link_chain2(star->text, rest->text);
    
    tptr->tid = RID_PTR;
    tptr->text = (StrTab *)NULL;
    tptr->size = SIZE_PTR;
    /* special case: array of pointers
     * '*' is parsed after [ ], therefore array size has to be corrected
     */
    if ( TID(iptr->type) == RID_ARRAY ) {
	iptr->type->size = iptr->type->totelem * SIZE_PTR;
    }
    
    for(p = &iptr->type;
	*p != currdecl->type;
	p = (Type **) &((*p)->link) );
    
    tptr->link = *p;
    *p  = tptr;
}


void pointer_type_decl(Lex *star, Lex *rest)
{
    Type **p;
    Type *tptr = newtype();
    
    rest->text = link_chain2(star->text, rest->text);
    
    tptr->tid = RID_PTR;
    tptr->text = (StrTab *)NULL;
    tptr->size = SIZE_PTR;
    
    for(p = (Type **) &(rest->tinfo);
	*p != currdecl->type;
	p = (Type **) &((*p)->link) );
    
    tptr->link = *p;
    *p  = tptr;
}

/* recompute array size as you add dimensions */
int adjust_array(Type *next, int elements)
{
    if (next->tid != RID_ARRAY)
      error("adjust_array called with on non array\n");

    if (((Type *)(next->link))->tid == RID_ARRAY) {
	next->totelem = ((Type *)(next->link))->totelem;
	next->size = next->totelem * adjust_array(next->link, elements);
    } else {
	next->totelem = elements;
	next->size = elements * SIZE((Type *)(next->link));
    }
    return(next->size);
}


void array_decl(Lex *rest, Lex *left, Lex *expr, Lex *right)
{  
    int numval = ((Expr *)expr->tinfo)->numval;
    
    rest->text = link_chain4(rest->text, left->text, expr->text, right->text);
    
    if ( numval == NONUMVAL && SHARED_FLAG ) {
	error("variable size shared arrays are not allowed");
    } else {
	Type *tptr = newtype();
	Symbol *iptr = (Symbol *)rest->tinfo;
	
	tptr->tid = RID_ARRAY;
	tptr->text = (StrTab *)NULL;
	tptr->totelem = (numval == NONUMVAL) ? ERROR : numval;
	tptr->size    = (numval == NONUMVAL) ? ERROR : 
	  numval * SIZE(iptr->type);
	tptr->link = iptr->type;
	iptr->type = tptr;
	adjust_array(tptr, tptr->totelem);
    }
}




void array_type_decl(Lex *rest, Lex *left, Lex *expr, Lex *right)
{  
    int numval = ((Expr *)expr->tinfo)->numval;
    
    rest->text = link_chain4(rest->text, left->text, expr->text, right->text);
    
    if ( numval == NONUMVAL && SHARED_FLAG )
      error("variable size shared arrays are not allowed");
    else
      {
	  Type *tptr = newtype();
	  
	  tptr->tid     = RID_ARRAY;
	  tptr->text    = (StrTab *)NULL;
	  tptr->totelem = (numval == NONUMVAL) ? ERROR : numval;
	  tptr->size    = (numval == NONUMVAL) ? ERROR : 
	    numval * SIZE( (Type *)rest->tinfo );
	  tptr->link    = (Type *)rest->tinfo;
	  rest->tinfo   = (Word)tptr;
      }
}



void empty_array_decl(Lex *rest, Lex *left, Lex *right)
{
    rest->text = link_chain3(rest->text, left->text, right->text);
    
    if ( SHARED_FLAG )
      error("null dimension in shared array declaration");
    else
      {
	  Type *tptr = newtype();
	  Symbol *iptr = (Symbol *)rest->tinfo;
	  
	  tptr->tid = RID_ARRAY;
	  tptr->text = (StrTab *)NULL;
	  tptr->totelem = ERROR;
	  tptr->size = ERROR;
	  tptr->link = iptr->type;
	  iptr->type = tptr;
      }
}


void empty_array_type_decl(Lex *rest, Lex *left, Lex *right)
{
    Type *tptr = newtype();
    
    rest->text = link_chain3(rest->text, left->text, right->text);
    
    tptr->tid = RID_ARRAY;
    tptr->text = (StrTab *)NULL;
    tptr->totelem = ERROR;
    tptr->size = ERROR;
    tptr->link = (Type *)rest->tinfo;
    rest->tinfo = (Word)tptr;
}



void func_decl(Lex *rest, Lex *left, Lex *parms)
{
    Type **p, **q;
    Type *tptr = newtype();
    Symbol *iptr = (Symbol *)rest->tinfo;
    
    rest->text = link_chain3(rest->text, left->text, parms->text);
    
    tptr->tid = RID_FUNC;
    tptr->text = (StrTab *)NULL;
    tptr->size = ERROR;
    
    for(q = (Type **)NULL, p = &iptr->type; 
	*p != currdecl->type;
	q = p, p = (Type **) &((*p)->link) );
    
    if (SHARED_FLAG
	&& (q == (Type **)NULL || (*q)->tid != RID_PTR)) {
	error("`shared' is not allowed in function declarations");
    }
    
    tptr->link = *p;
    *p  = tptr;
    
}


void func_type_decl(Lex *rest, Lex *left, Lex *parms)
{
    Type **p;
    Type *tptr = newtype();
    
    rest->text = link_chain3(rest->text, left->text, parms->text);
    
    tptr->tid = RID_FUNC;
    tptr->text = (StrTab *)NULL;
    tptr->size = ERROR;

    for(p = (Type **) &(rest->tinfo);
	*p != currdecl->type;
	p = (Type **) &((*p)->link) );
    
    tptr->link = *p;
    *p  = tptr;
}


#define min(a, b)             (((a)<(b)) ? (a) : (b))

static int calc_offsets(Symbol *comp)
{
    int curroffset = 0;
    int currsize =   4;
    
    for( ; comp != (Symbol *)NULL; comp = comp->right) {
	currsize = SIZE(comp->type);
	
	comp->offset = ROUND( curroffset, min(currsize, sizeof(Word)) );
	curroffset = comp->offset + currsize;
    }
    
    return( ROUND(curroffset, min(currsize, sizeof(Word)) ) );
}



void make_empty_structure(Lex *name)
{
    char sname[64];
    Symbol *iptr, *sptr;
    Type *tptr;
    Lex sym;

    sym = lookup_structure(name, 0);
    sptr = (Symbol *) sym.tinfo;

    if (sptr == NULL || sptr->class != ID_COMPOUND
	|| sptr->level < curr_tree_level
	|| sptr->type->tid != RID_STRUCT) {
        tptr = newtype();
	iptr = newsymbol();
	iptr->class = ID_COMPOUND;
	iptr->type  = tptr;
	tptr->tid   = RID_STRUCT;
	strcpy(sname, "struct ");
	strcat(sname, TEXT(name->text) );
	tptr->text  = allocate_string(sname);
	iptr->text  = allocate_string(sname);
	tptr->size = ERROR;
	tptr->link = (Symbol *)NULL;
	name->tinfo = (Word)iptr;
	insert_symbol( iptr, currtree );
    } else {
#ifdef DEBUG
	printf("%s:%d: found %s, not making structure\n", input_filename,
	       lineno, TEXT(name->text));
#endif
	insert_symbol( sptr, currtree);
	name->tinfo = (Word)sptr;
    }
}



void fill_structure(Lex *name, Lex *components)
{
    Symbol *iptr;
    Type *tptr;
    
#ifdef DEBUG
    printf("%s:%d: fill_structure(%s)\n", input_filename, lineno,
	   TEXT(name->text));
#endif
    iptr = (Symbol *)name->tinfo;
#ifdef DEBUG
    print_type(iptr->type);
#endif
    tptr = iptr->type;
    tptr->link  = (Symbol *)components->tinfo;
    tptr->size  = calc_offsets((Symbol *)components->tinfo);
    
}



static int calc_unionsize(Symbol *comp)
{
    int unionsize = 0;
    
    for( ; comp != (Symbol *)NULL; comp = comp->right)
      {
	  comp->offset = 0;
	  unionsize = max(unionsize, SIZE(comp->type) );
      }
    
    return( unionsize );
}



void make_empty_union(Lex *name)
{
    char sname[64];
    Symbol *iptr, *sptr;
    Type *tptr;
    Lex sym;

    sym = lookup_union(name, 0);
    sptr = (Symbol *) sym.tinfo;

    if (sptr == NULL || sptr->class != ID_COMPOUND
	|| sptr->level < curr_tree_level
	|| sptr->type->tid != RID_UNION) {
        tptr = newtype();
        iptr = newsymbol();
	iptr->class = ID_COMPOUND;
	iptr->type  = tptr;
	tptr->tid   = RID_UNION;
	strcpy(sname, "union ");
	strcat(sname, TEXT(name->text) );
	tptr->text  = allocate_string(sname);
	iptr->text  = allocate_string(sname);
	tptr->size = ERROR;
	tptr->link = (Symbol *)NULL;
	name->tinfo = (Word)iptr;
	insert_symbol( iptr, currtree );
    } else {
#ifdef DEBUG
	printf("%s:%d: found %s, not making union\n", input_filename,
	       lineno, TEXT(name->text));
#endif
	insert_symbol( sptr, currtree);
	name->tinfo = (Word)sptr;
    }
}


void fill_union(Lex *name, Lex *components)
{
    Symbol *iptr = (Symbol *)name->tinfo;
    Type *tptr = iptr->type;
    
    tptr->link  = (Symbol *)components->tinfo;
    tptr->size  = calc_unionsize((Symbol *)components->tinfo);
}



void make_enum(Lex *name)
{
    char sname[64];
    Symbol *iptr = newsymbol();
    Type *tptr = newtype();
    
    iptr->class = ID_COMPOUND;
    iptr->type  = tptr;
    tptr->tid = RID_ENUM;
    strcpy(sname, "enum ");
    strcat(sname, TEXT(name->text));
    tptr->text = allocate_string(sname);
    iptr->text = allocate_string(sname);
    tptr->size = SIZE_ENUM;
    
    insert_symbol( iptr, currtree );
    
    name->tinfo = (Word)iptr;
}




void insert_enum_ident(Lex *name)
{
    Symbol *iptr = newsymbol();
    
    iptr->class = ID_ENUMID;
    iptr->type  = (Type *)NULL;
    iptr->text  = copy_string( name->text );
    
    insert_symbol( iptr, currtree );
    
    name->tinfo = (Word)iptr;
}



void link_components(Lex *l1, Lex *l2)
{
    Symbol *list = (Symbol *)l1->tinfo;
    Symbol *new  = (Symbol *)l2->tinfo;
    
    if (list == (Symbol *)NULL)
      l1->tinfo = l2->tinfo;
    else
      {
	  for(; list->right != (Symbol *)NULL; list = list->right);
	  list->right = new;
      }
}



void new_scspec(Lex *lex)
{
    switch( lex->tinfo )
      {
	case RID_SHARED:
	  if ( TYPEDEF_FLAG ) {
	      warning("shared ignored in typedef");
	      return;
	  }
	  break;
	case RID_TAGGED:
	case RID_UNTAGGED:
	case RID_SOFT:
	  free_chain( lex->text );
	  (lex->text)->text = 0;
	  break;
	case RID_TYPEDEF:
	  if ( SHARED_FLAG ) {
	      warning("shared ignored in typedef");
	      currdecl->attributes &= (~RID_SHARED);
	  }
      }
    currdecl->attributes |= lex->tinfo;
}


void add_scspec(Lex *rest, Lex *new)
{
    new_scspec(new);
    rest->text = link_chain2( rest->text, new->text);
}



void new_typequal(Lex *lex)
{
    currdecl->typequals |= lex->tinfo;
}


void add_typequal(Lex *rest, Lex *new)
{
    currdecl->typequals |= new->tinfo;
    rest->text = link_chain2( rest->text, new->text);
}


void placement_directive(Lex *s, Lex *where)
{
    ((Symbol *)s->tinfo)->processor = atoi(TEXT(where->text))+1;
}



Lex new_internal_name()
{
    
    static int internal_name = 0;
    
    Lex lex;
    char name[20];
    
    sprintf(name, "__intrnl_%d", internal_name++);
    lex.text = allocate_string(name);
    
    return( lex );
}


char  error_flag,  xdecls_flag;


/* TEMPORARY =========================================================== */

Expr *make_expr(Lex *name)
{
    Expr *newexpr();
    Expr *expr = newexpr();
    
    expr->numval = atoi( TEXT(name->text) );
    
    return(expr);
}
