
#include <stdio.h>

/* global variablel used by augmented code */
unsigned long stackmin_ = 0x1000000;
unsigned long base_time_ = 100000000;
unsigned long cycles_ =    100000000;
#define CURRENT_TIME (base_time_ - cycles_)

/* primitive commands for turning cycle counting on and off */
volatile int counting_on, counting_off;
/* Macros to control cycle counting */
#define CYCLE_COUNTING_ON  (void)counting_on
#define CYCLE_COUNTING_OFF (void)counting_off

/* routines called by augmented code */

void SimStack()
{
    fprintf(stderr, "Stack overflow\n");
    exit(2);
}

void SimQuantum() {}

/* stupid prime number routine */

static int prime(int n)
{
    int i, j, num_primes;
    int primes[1000];

    if (n > 1000) {
	fprintf(stderr, "n must be less than or equal to 1000\n");
	exit(1);
    } else if (n < 1) {
	fprintf(stderr, "n must be greater than 0\n");
	exit(1);
    }

    primes[0] = 2;
    primes[1] = 3;
    num_primes = 2;

    for (i = 5; ; i += 2) {
	for (j = 0; j < num_primes; j++) {
	    if (i % primes[j] == 0) break;
	}
	if (j == num_primes) {
	    /* printf("prime(%d) = %d\n", num_primes + 1, i); */
	    primes[num_primes++] = i;
	    if (num_primes >= n) return(primes[n-1]);
	}
    }

    /* unreachable */
}


void main(int argc, char **argv)
{
    int i, time100, time200, time500;
    unsigned long start, end;

    start = CURRENT_TIME;
    i = 100;
    printf("Prime number %d = %d  (should be 541)\n", i, prime(i));
    end = CURRENT_TIME;
    time100 = end - start;

    printf("Cycles = %lu\n", time100);


    start = CURRENT_TIME;
    i = 200;
    printf("Prime number %d = %d  (should be 1223)\n", i, prime(i));
    end = CURRENT_TIME;
    time200 = end - start;

    printf("Cycles = %lu\n", time200);


    start = CURRENT_TIME;
    i = 500;
    printf("Prime number %d = %d  (should be 3571)\n", i, prime(i));
    end = CURRENT_TIME;
    time500 = end - start;

    printf("Cycles = %lu\n", time500);

    printf("\n***\n\n");
    printf("The cycle times ratios should be 1.0 : 3.8 : 23 (roughly).\n");
    printf("\nActual ratios =  1.0 : %.1f : %.0f\n\n",
	   time200 /(float)time100,
	   time500 /(float)time100);
}
