/****************************************************************************
*****************************************************************************

Parallel Architecture Simulator
Eric A. Brewer  and  Chris N. Dellarocas
Laboratory for Computer Science
Massachusetts Institute of Technology

Module:  Augment -- Load PMAX instructions.

Description:
    Loads the PMAX instruction set into the symbol table.

Last Modified: 4-26-90  (eab)

Global Functions:
    void LoadInstructions()
        Loads the instruction set of the pmax into the symbol table.
	Assumes symbol table has been initialized (with InitTable).

Global Variables:
    none

****************************************************************************
*   Copyright 1991                                                       
*   Eric A. Brewer  and  Chris N. Dellarocas                             
*   Massachusetts Institute of Technology                                
*                                                                        
*   Permission to use, copy, modify, and distribute this program         
*   for any purpose and without fee is hereby granted, provided          
*   that this copyright and permission notice appear on all copies       
*   and supporting documentation, the name of M.I.T. not be used         
*   in advertising or publicity pertaining to distribution of the        
*   program without specific prior permission, and notice be given       
*   in supporting documentation that copying and distribution is         
*   by permission of M.I.T.  M.I.T. makes no representations about       
*   the suitability of this software for any purpose.  It is pro-        
*   vided "as is" without express or implied warranty.		          
*****************************************************************************
****************************************************************************/

#include <stdio.h>
#include "lex.h"  /* for symbol types */

extern char *InsertSymbolValue(const char *name, int symbol_type, long value);
const char *lw_inst_ptr; /* string for "lw" instruction */

void LoadInstructions()
{
    /* load/store instructions */
    InsertSymbolValue("lb", SYM_INST2, 1);
    InsertSymbolValue("lbu", SYM_INST2, 1);
    InsertSymbolValue("lh", SYM_INST2, 1);
    InsertSymbolValue("lhu", SYM_INST2, 1);
    lw_inst_ptr = InsertSymbolValue("lw", SYM_INST2, 1);
    InsertSymbolValue("ulw", SYM_INST2, 1); /* added for gcc 2.1 */
    InsertSymbolValue("la", SYM_INST2, 2);
    InsertSymbolValue("li", SYM_INST2, 1); /* cc only */
    InsertSymbolValue("ld", SYM_INST2, 1); /* cc only */
    InsertSymbolValue("lwl", SYM_INST2, 1);
    InsertSymbolValue("lwr", SYM_INST2, 1);
    InsertSymbolValue("lui", SYM_INST3, 1);
    InsertSymbolValue("sb", SYM_INST2, 1);
    InsertSymbolValue("sh", SYM_INST2, 1);
    InsertSymbolValue("sw", SYM_INST2, 1);
    InsertSymbolValue("usw", SYM_INST2, 1);
    InsertSymbolValue("sd", SYM_INST2, 1);
    InsertSymbolValue("swl", SYM_INST2, 1);
    InsertSymbolValue("swr", SYM_INST2, 1);
    InsertSymbolValue("mov", SYM_INST3, 1);
    InsertSymbolValue("move", SYM_INST2, 1); /* cc only */

    /* computational instructions */
    InsertSymbolValue("addi", SYM_INST3, 1);
    InsertSymbolValue("addiu", SYM_INST3, 1);
    InsertSymbolValue("slti", SYM_INST3, 1);
    InsertSymbolValue("sltiu", SYM_INST3, 1);
    InsertSymbolValue("andi", SYM_INST3, 1);
    InsertSymbolValue("ori", SYM_INST3, 1);
    InsertSymbolValue("xori", SYM_INST3, 1);
    InsertSymbolValue("add", SYM_INST3, 1);
    InsertSymbolValue("addu", SYM_INST3, 1);
    InsertSymbolValue("seq", SYM_INST3, 1);
    InsertSymbolValue("sne", SYM_INST3, 1);
    InsertSymbolValue("not", SYM_INST2, 1);
    InsertSymbolValue("sub", SYM_INST3, 1);
    InsertSymbolValue("subu", SYM_INST3, 1);
    InsertSymbolValue("slt", SYM_INST3, 1);
    InsertSymbolValue("sltu", SYM_INST3, 1);
    InsertSymbolValue("sgt", SYM_INST3, 1);
    InsertSymbolValue("sgtu", SYM_INST3, 1);
    InsertSymbolValue("and", SYM_INST3, 1);
    InsertSymbolValue("or", SYM_INST3, 1);
    InsertSymbolValue("xor", SYM_INST3, 1);
    InsertSymbolValue("nor", SYM_INST3, 1);
    InsertSymbolValue("rem", SYM_INST3, 1); /* cc only */
    InsertSymbolValue("remu", SYM_INST3, 1); /* cc only */

    /* shift instructions */
    InsertSymbolValue("sll", SYM_INST3, 1);
    InsertSymbolValue("srl", SYM_INST3, 1);
    InsertSymbolValue("sra", SYM_INST3, 1);
    InsertSymbolValue("sllv", SYM_INST3, 1);
    InsertSymbolValue("srlv", SYM_INST3, 1);
    InsertSymbolValue("srav", SYM_INST3, 1);

    /* multiply/divide instructions */
    InsertSymbolValue("mult", SYM_INST2, 2);
    InsertSymbolValue("multu", SYM_INST2, 2);
    InsertSymbolValue("mul", SYM_INST3, 2);
    InsertSymbolValue("div", SYM_INST2, 2);
    InsertSymbolValue("divu", SYM_INST2, 2);
    InsertSymbolValue("mfhi", SYM_INST1, 1);
    InsertSymbolValue("mflo", SYM_INST1, 1);
    InsertSymbolValue("mthi", SYM_INST1, 1);
    InsertSymbolValue("mtlo", SYM_INST1, 1);

    /* jump/branch instructions */
    InsertSymbolValue("j", SYM_INST1 | SYM_JUMP, 1);
    InsertSymbolValue("jal", SYM_INST1 | SYM_CALL, 1);
    InsertSymbolValue("jr", SYM_INST1, 1);
    InsertSymbolValue("jalr", SYM_INST2, 1);
    InsertSymbolValue("beq", SYM_INST3 | SYM_BRANCH, 1);
    InsertSymbolValue("bne", SYM_INST3 | SYM_BRANCH, 1);
    InsertSymbolValue("bnez", SYM_INST2 | SYM_BRANCH, 1);
    InsertSymbolValue("beqz", SYM_INST2 | SYM_BRANCH, 1);
    InsertSymbolValue("blez", SYM_INST2 | SYM_BRANCH, 1);
    InsertSymbolValue("bgtz", SYM_INST2 | SYM_BRANCH, 1);
    InsertSymbolValue("bltz", SYM_INST2 | SYM_BRANCH, 1);
    InsertSymbolValue("bgez", SYM_INST2 | SYM_BRANCH, 1);
    InsertSymbolValue("ble", SYM_INST3 | SYM_BRANCH, 1);
    InsertSymbolValue("bgt", SYM_INST3 | SYM_BRANCH, 1);
    InsertSymbolValue("blt", SYM_INST3 | SYM_BRANCH, 1);
    InsertSymbolValue("bge", SYM_INST3 | SYM_BRANCH, 1);
    InsertSymbolValue("bleu", SYM_INST3 | SYM_BRANCH, 1);
    InsertSymbolValue("bgtu", SYM_INST3 | SYM_BRANCH, 1);
    InsertSymbolValue("bltu", SYM_INST3 | SYM_BRANCH, 1);
    InsertSymbolValue("bgeu", SYM_INST3 | SYM_BRANCH, 1);
    InsertSymbolValue("bltzal", SYM_INST2 | SYM_BRANCH, 1);
    InsertSymbolValue("bgezal", SYM_INST2 | SYM_BRANCH, 1);
    InsertSymbolValue("b", SYM_INST1 | SYM_BRANCH, 1); /* cc only */

    /* special instructions */
    InsertSymbolValue("syscall", SYM_INST0, 1);
    InsertSymbolValue("break", SYM_INST0, 1);
    InsertSymbolValue("nop", SYM_INST0, 1);

    /* coprocessor instructions */
    InsertSymbolValue("lwc1", SYM_INST2, 1);
    InsertSymbolValue("swc1", SYM_INST2, 1);
    InsertSymbolValue("mtc1", SYM_INST2, 1);
    InsertSymbolValue("mfc1", SYM_INST2, 1);
    InsertSymbolValue("ctc1", SYM_INST2, 1);
    InsertSymbolValue("cfc1", SYM_INST2, 1);
    InsertSymbolValue("l", SYM_INST2, 1);
    InsertSymbolValue("s", SYM_INST2, 1);
    InsertSymbolValue("abs", SYM_INST2, 1);
    InsertSymbolValue("neg", SYM_INST2, 1);
    InsertSymbolValue("negu", SYM_INST2, 1);
    InsertSymbolValue("cvt", SYM_INST2, 1);
    InsertSymbolValue("c", SYM_INST2, 1);
    InsertSymbolValue("trunc", SYM_INST3, 1);
    InsertSymbolValue("truncu", SYM_INST3, 1);

    InsertSymbolValue("bc1t", SYM_INST1 | SYM_BRANCH, 1);
    InsertSymbolValue("bc1f", SYM_INST1 | SYM_BRANCH, 1);

    /* system control coprocessor instructions */
    InsertSymbolValue("mtc0", SYM_INST2, 1);
    InsertSymbolValue("mfc0", SYM_INST2, 1);
    InsertSymbolValue("tlbr", SYM_INST0, 1);
    InsertSymbolValue("tlbwi", SYM_INST0, 1);
    InsertSymbolValue("tlbwr", SYM_INST0, 1);
    InsertSymbolValue("tlbp", SYM_INST0, 1);
    InsertSymbolValue("rfe", SYM_INST0, 1);
}
