/* basic memory routines */

#include <stddef.h>

char *memccpy(char *s1, char *s2, int c, size_t n)
{
    size_t i;

    for (i=0; i<n; i++) {
	*s1 = *s2++;
	if (*s1++ == c) return(s1);
    }
    return(NULL);
}


char *memchr(char *s, int c, size_t n)
{
    size_t i;

    for (i=0; i<n; i++) {
	if (*s == c) return(s);
	s++;
    }
    return(NULL);
}


char *memcpy(char *s1, char *s2, size_t n)
{
    char *tmp = s1;

    while (n > 0) {
	*tmp++ = *s2++;
	n--;
    }
    return(s1);
}


int memcmp(char *s1, char *s2, size_t n)
{
    size_t i;

    for (i=0; i<n; i++) {
	if (*s1 != *s2)
	  return( (int) (s1 - s2) );
	s1++;
	s2++;
    }
    return(0);
}


char *memset(char *s, int c, size_t n)
{
    char *tmp = (char *)s;

    while (n > 0) {
	*tmp++ = (char)c;
	n--;
    }
    return(s);
}


char *memmove(char *s1, char *s2, size_t n)
{
    size_t i;
    char *tmp = s1, *tmp1, *tmp2;

    if (s1 > s2) {
	tmp1 = s1 + n;
	tmp2 = s2 + n;
	for (i=n; i>0; i--) *(--tmp1) = *(--tmp2);
    } else {
	for (i=0; i<n; i++) *tmp++ = *s2++;
    }
    return(s1);
}


void bzero(char *s, size_t n)
{
    for (; n>0; n--) {
	*s++ = 0;
    }
}


void bcopy(char *s2, char *s1, int n)
{
    char *tmp1, *tmp2;
    size_t i;

    if (s1 > s2) {
	tmp1 = s1 + n;
	tmp2 = s2 + n;
	for (i=n; i>0; i--) *(--tmp1) = *(--tmp2);
    } else {
	for (i=0; i<n; i++) *s1++ = *s2++;
    }
}


int bcmp(char *s2, char *s1, int n)
{
    int i;

    for (i=0; i<n; i++) {
	if (*s1 != *s2)
	  return( (int) (s1 - s2) );
	s1++;
	s2++;
    }
    return(0);
}
