/* malloc headers
   Eric A. Brewer
   October 31, 1990
*/

extern unsigned long cycles_;
extern char *malloc(), *realloc(), *calloc();
extern free();

#define MALLOC_TIME 50
#define FREE_TIME 40

char *cyc_malloc(size)
unsigned size;
{
    cycles_ -= MALLOC_TIME;
    return(malloc(size));
}

char *cyc_realloc(ptr, size)
char *ptr; unsigned size;
{
    cycles_ -= MALLOC_TIME + size/4;
    return(realloc(ptr, size));
}

char *cyc_calloc(nelem, elsize)
unsigned nelem, elsize;
{
    cycles_ -= MALLOC_TIME + (nelem*elsize)/4;
    return(calloc(nelem, elsize));
}

cyc_free(ptr)
char *ptr;
{
    cycles_ -= FREE_TIME;
    free(ptr);
}
