/****************************************************************************
*****************************************************************************

Parallel Architecture Simulator
Eric A. Brewer  and  Chris N. Dellarocas
Laboratory for Computer Science
Massachusetts Institute of Technology

Module:  Augment -- lex/symbol table header

Description:
    Defines lex tokens and symbol table types.  Defines types 'BOOL' and
    'nodeType'.

Last Modified: 4-26-90  (eab)

Data Structures:
    Type BOOL -- booleans
    Type nodeType -- basic block nodes

Constants:
    For 'lex':  tokens, LINE_MAX
    Types for symbols (used in the symbol table).
    
Variables:
    none

****************************************************************************
*   Copyright 1991                                                       
*   Eric A. Brewer  and  Chris N. Dellarocas                             
*   Massachusetts Institute of Technology                                
*                                                                        
*   Permission to use, copy, modify, and distribute this program         
*   for any purpose and without fee is hereby granted, provided          
*   that this copyright and permission notice appear on all copies       
*   and supporting documentation, the name of M.I.T. not be used         
*   in advertising or publicity pertaining to distribution of the        
*   program without specific prior permission, and notice be given       
*   in supporting documentation that copying and distribution is         
*   by permission of M.I.T.  M.I.T. makes no representations about       
*   the suitability of this software for any purpose.  It is pro-        
*   vided "as is" without express or implied warranty.		          
*****************************************************************************
****************************************************************************/

#ifndef __STDC__  /* remove const keyword if using cc */
#define const
#endif

#define GLOBAL
#define LIBRARY extern


/* lex token types */
#define ID      256
#define REG     257
#define NUM     258
#define OFFSET  259
#define DIR     260
#define STRING  261
#define LABEL   262
#define ERROR   263

#define LINE_MAX       4000      /* max characters per line */


/* symbol types */
#define SYM_EMPTY        0
#define SYM_INST0        1      /* 0 arg instructions */
#define SYM_INST1        2      /* 1 arg instructions */
#define SYM_INST2        4      /* 2 arg instructions */
#define SYM_INST3        8      /* 3 arg instructions */
#define SYM_INST        15      /* any instruction */
#define SYM_LABEL       16      /* labels */
#define SYM_DIR         32      /* directives */
#define SYM_IDENT       64      /* identifiers */
#define SYM_CALL       128      /* marks CALL instruction */
#define SYM_BRANCH     256      /* marks BRANCH instruction */
#define SYM_JUMP       512      /* makes a non-call JUMP instruction */
#define SYM_LIB       1024      /* library routine to be changed to cycle
				   counting library */
#define SYM_NOCYC     2048      /* routines missing from cycle counting lib */

/* boolean declarations */
typedef short BOOL;
#define TRUE 1
#define FALSE 0

typedef enum { NO_CHANGE=0, ON, OFF } changeType;

/* graph declarations */
typedef struct nT {
    int start, end;       /* text line numbers */
    const char *label;    /* label of node (if there is one) */
    BOOL label_block;     /* TRUE iff this node created by a label */
    struct nT *follow;    /* fall through node */
    struct nT *alt;       /* alternate node (for branch) */
    int count;            /* instruction count */
    BOOL unref;           /* TRUE iff this node created because of an
			       unreferenced label */
    BOOL noat;            /* TRUE iff the start of this node is in an area
			     where ".set noat" is true */
    BOOL optimize;        /* TRUE if safe to leave out quantum expired check */
    BOOL read_cycles;     /* TRUE iff this block ended with
			     "lw reg, current_time_" */
    changeType change;    /* ON to turn on cycle counting;
			     or OFF or NO_CHANGE */
    BOOL noreorder;       /* TRUE iff the start of this node is in an area
			     where ".set noreorder" holds */
    BOOL nomacro;         /* TRUE iff the start of this node is in an area
			     where ".set nomacro" holds */
                          /* following fields used to detect epilogue jump */
    int last_jump;        /* line number of last jump in block */
    BOOL noreorder_jump;   /* TRUE iff last jump in noreorder area */
    BOOL nomacro_jump;    /* TRUE iff last jump in nomacro area */
} nodeType;

#ifdef DEBUG
#include <assert.h>
#else
#define assert(x) {}
#endif
