%{
/****************************************************************************
*****************************************************************************

Parallel Architecture Simulator
Eric A. Brewer  and  Chris N. Dellarocas
Laboratory for Computer Science
Massachusetts Institute of Technology

Module:  Augment -- lex definition

Description:
    Lexical Analyzer for 'augment'.   Parses PMAX assembly code.
    
Last Modified:  4-26-90  (eab)

Global Functions:
    int yylex()
        Returns next token.

Global Variables:
    char tmp[1000];
        Input line that is currently being parsed is stored here.
    char *cur;
        Points to the last character parsed; initially cur = &tmp[0],
        then cur moves through tmp as the line is parsed.
    char *yytext;
        Points to the text of the current token.

****************************************************************************
*   Copyright 1991                                                       
*   Eric A. Brewer  and  Chris N. Dellarocas                             
*   Massachusetts Institute of Technology                                
*                                                                        
*   Permission to use, copy, modify, and distribute this program         
*   for any purpose and without fee is hereby granted, provided          
*   that this copyright and permission notice appear on all copies       
*   and supporting documentation, the name of M.I.T. not be used         
*   in advertising or publicity pertaining to distribution of the        
*   program without specific prior permission, and notice be given       
*   in supporting documentation that copying and distribution is         
*   by permission of M.I.T.  M.I.T. makes no representations about       
*   the suitability of this software for any purpose.  It is pro-        
*   vided "as is" without express or implied warranty.		          
*****************************************************************************
****************************************************************************/

#include <string.h>
#include <stdlib.h>
#include "lex.h"

extern void EnqueueLibCall(char *call);
extern char *LocateSymbol(char *sym, int styp);
extern nodeType *curNode;

#undef YYLMAX
#define YYLMAX LINE_MAX

%}

%%

\,		           |
\.                         |
\(		           |
\)		           return(yytext[0]);

\$\$[A-Za-z0-9_]*          |
\$?[A-Za-z_][A-Za-z0-9_]*  {
                             char *id;
                             if (strcmp(yytext, "$sp") == 0)
                                 return(REG);
                             if (strcmp(yytext, "$fp") == 0)
                                 return(REG);
			     if ((id=LocateSymbol(yytext, SYM_LIB)) != NULL) {
				 EnqueueLibCall(id);
			     }
			     return(ID);
			   }
\$*[A-Za-z0-9_.]+: 
                           {
                             char *id;
			     yytext[yyleng - 1] = 0; /* hide colon */
                             if ((id=LocateSymbol(yytext, SYM_LIB)) != NULL) {
				 EnqueueLibCall(id);
			     }
			     yytext[yyleng - 1] = ':'; /* restore colon */
			     return(LABEL);
                           }
\".*\"                     return(STRING);
\$[0-9]+	           {
                             if (atoi(&yytext[1]) > 31)
                               return(ID);
                             else
                               return(REG);
                           }
0x[0-9a-fA-F]+             return(NUM);
\-?[0-9]+                  return(OFFSET);
\.[A-Za-z]+                return(DIR);
\#.*                       ;
[ 	]	           ;
.		           return(ERROR);

%%

char tmp[LINE_MAX], *cur;

#undef input
#define input()	(*cur++)
#undef unput
#define unput(c) { cur--; *cur=(c); }
#undef output
#define output(c) {}

static int yywrap() { return 1; }

