/******************************************************************************
*
*  Copyright (C) 1995 A. Bode, J. Pruyne and G. Stellner
*
*  This file is part of CoCheck
*
*  CoCheck is free software; you can redistribute it and/or
*  modify it under the terms of the GNU Library General Public
*  License as published by the Free Software Foundation; either
*  version 2 of the License, or (at your option) any later version.
*
*  CoCheck is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*  Library General Public License for more details.
*
*  You should have received a copy of the GNU Library General Public
*  License along with this library; if not, write to the Free
*  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*  Contact to the authors:
*
*  electronic mail: {bode,stellner}@informatik.tu-muenchen.de
*
*  paper mail:      Prof. Dr. A. Bode
*                   Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                   Institut f"ur Informatik
*                   Technische Universit"at M"unchen
*                   80290 M"unchen
*                   Germany
*
******************************************************************************/
/******************************************************************************

  rensym.c,v
  1995/11/07 13:51:52
  1.3
  Exp
  stellner

  Authors: G. Stellner

  Description: Tool to rename symbols in a library

******************************************************************************/
static char rcs_id[] = "rensym.c,v 1.3 1995/11/07 13:51:52 stellner Exp";

#include <stdio.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>

#define SYM1 "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"
#define SYM2 ".abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_0123456789"
#define USAGE "Usage: %s file sym_1 newsym_1 sym_2 newsym_2 sym_n newsym_n \n"

int main(argc,argv)
int argc;
char **argv;
{
  int fd, retv;
  int k, i, j;
  int wordlen, match, count;
  struct stat fstatbuf;
  off_t filelength;
  char *buf;
  char *symb, *repsymb;

  if(argc < 4 || argc%2)
  {
    printf(USAGE, argv[0]);
    exit(1);
  }

  if ((fd = open(argv[1], O_RDWR, 0)) < 0)
  {
    fprintf(stderr,"%s: cannot open %s\n", argv[0], argv[1]);
    exit(1);
  }

  retv = fstat(fd, &fstatbuf);  /* look at the file */
  filelength = fstatbuf.st_size; /* get its size */

  if ((buf = (char *) malloc(filelength)) == NULL)
  {
    fprintf(stderr, "%s: not enough memory for %s\n", argv[0], argv[1]);
    exit(1);
  }

  read(fd, buf, filelength);

  for (k=2; k<argc; k+=2)
  {
    count = 0;
    symb = strdup(argv[k]);
    repsymb = strdup(argv[k+1]);

    if ((wordlen = strlen(symb)) != strlen(repsymb))
    {
      printf("%s: symbol(%s) and newsymbol(%s) need same length\n",
             argv[0], symb, repsymb);
      continue;
    }

    printf("%s: renaming %s to %s in %s->", argv[0], symb, repsymb, argv[1]);
    fflush(stdout);

    for (i=0; i<=filelength-wordlen; i++)
    {
      if (buf[i] == symb[0])      /* first char matches */
      {
        if ((i == 0) || (strspn(buf+i-1, SYM1) == 0)) /* no char before that */
        {
          match=0;                /* everything ok up to now */

          for (j=0; j<wordlen; j++) /* look at all the other chars */
            if(buf[i+j] != symb[j]) /* does it match */
              match++;            /* no, sorry no match */

          if ((strspn(buf+i+j, SYM2) != 0)) /* char after that */
            match++;              /* yes, sorry no match */

          if(!match)              /* real match found */
          {
            lseek(fd, i, SEEK_SET);
            write(fd, repsymb, wordlen); /* substitute the symbol */
            count++;
          }
        }
      }
    }

    printf("%d\n", count);

    if (count == 0)
      fprintf(stderr, "%s: symbol(%s) not found\n", argv[0], symb);

    free(symb);
    free(repsymb);
  }

  close(fd);

  /* printf(" %s: %s found %d time[s]\n",argv[1],argv[2],count); */

  exit(0);
}
