/******************************************************************************
*
*  Copyright (C) 1995 A. Bode, J. Pruyne and G. Stellner
*
*  This file is part of CoCheck
*
*  CoCheck is free software; you can redistribute it and/or
*  modify it under the terms of the GNU Library General Public
*  License as published by the Free Software Foundation; either
*  version 2 of the License, or (at your option) any later version.
*
*  CoCheck is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*  Library General Public License for more details.
*
*  You should have received a copy of the GNU Library General Public
*  License along with this library; if not, write to the Free
*  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*  Contact to the authors:
*
*  electronic mail: {bode,stellner}@informatik.tu-muenchen.de
*
*  paper mail:      Prof. Dr. A. Bode
*                   Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                   Institut f"ur Informatik
*                   Technische Universit"at M"unchen
*                   80290 M"unchen
*                   Germany
*
******************************************************************************/
/******************************************************************************

  mesbuf.c,v
  1995/11/07 13:51:38
  1.2

  Exp

  stellner

  Authors: G. Stellner

  Description: Routines for buffering messages

******************************************************************************/
static char rcs_id[] = "mesbuf.c,v 1.2 1995/11/07 13:51:38 stellner Exp";

#include <stdio.h>
#include <stdlib.h>

#include "pvm3.h"

#include "kojakmalloc.h"
#include "types.h"
#include "error.h"

extern int (*PVM_recvf())();

static Message MessageTable =
{
  -1, 0, &MessageTable, &MessageTable
};

static Message *GetMessageEntry()
{
  Message *p;

  p = (Message *)TMALLOC(1, Message, "MESSAGE");

  if (p == NULL)
    return(NULL);

  p->next = NULL;
  p->prev = NULL;

  return(p);
}

int _Save2Buf(mid, otid)
int mid;
int otid;
{
  Message *p;

  _Db(6, "_Save2Buf", _LOC_, "inserting mid %d 0x%x", mid, otid);

  p = GetMessageEntry();

  if (p == NULL)
  {
    _Error(WARN, "_Save2Buf", _LOC_, "no memory for message");
    return(-1);
  }

  MessageTable.otid += 1;        /* count inserted elms in tids field */

  _Db(6, "_Save2Buf", _LOC_, "now %d entries in table", MessageTable.otid);
  PVM_setrbuf(0);               /* make sure buffer isn't cleared */

  p->next = MessageTable.prev->next;
  p->prev = MessageTable.prev;
  MessageTable.prev->next = p;
  MessageTable.prev = p;

  p->mid = mid;
  p->otid = otid;

  return(0);
}

int _RecFromBuf(otid, tag)
int otid;
int tag;
{
  int cc;
  int ret = -1;
  int maxval = 1;
  Message *p;
  Message *maxp= NULL;
  int (*MatchMesFunc)() = NULL;

  MatchMesFunc = PVM_recvf(0);  /* get current receive match function */

  for (p=MessageTable.next; p!=&MessageTable; p=p->next)
  {
    cc = MatchMesFunc(p->mid, -1, tag); /* apply match func with any tid */

    if (p->otid == otid)        /* do the original tids match? */
    {                           /* a problem here is with user supplied */
                                /* matching functions. If the user provides */
      if (cc == 1)              /* a matching function which doesn't use */
      {                         /* tids as matching criteria then this */
        ret = p->mid;           /* doesn't maintain the semantics of the */
        break;                  /* user supplied function XXX */
      }

      if (cc > maxval)
      {
        maxval = cc;
        maxp = p;
        continue;
      }

      if (cc < 0)
      {
        ret = cc;
        break;
      }
    }
  }

  if (maxval != 1 && maxp != NULL)
  {
    p = maxp;
    ret = maxp->mid;
  }

  if (ret > 0)
  {
    _Db(0, "_RecFromBuf", _LOC_,
        "retrieved mid %d 0x%x, p *0x%x", p->mid, p->otid, p);

    MessageTable.otid -= 1;
    p->prev->next = p->next;
    p->next->prev = p->prev;

    FREE(p);
  }

  PVM_recvf(MatchMesFunc);      /* re-install current match function */

  return(ret);                   /* currently no messages in buffer */
}

void _PrintBufMsgs(s)
char *s;
{
  int i;
  int tag;
  int tid;
  Message *p;

  for (i=1, p=MessageTable.next; p!=&MessageTable; i++, p=p->next)
  {
    _Db(6, s, _LOC_, "%d in buffer  %d, %d 0x%x", i, p->mid, p->otid);
    PVM_bufinfo(p->mid, (int *)0, &tag, &tid);
    _Db(6, s, _LOC_, "%d in pvmbuf  %d, %d 0x%x", i, p->mid, tag, tid);
  }
}
