/******************************************************************************
*
*  Copyright (C) 1995 A. Bode, J. Pruyne and G. Stellner
*
*  This file is part of CoCheck
*
*  CoCheck is free software; you can redistribute it and/or
*  modify it under the terms of the GNU Library General Public
*  License as published by the Free Software Foundation; either
*  version 2 of the License, or (at your option) any later version.
*
*  CoCheck is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*  Library General Public License for more details.
*
*  You should have received a copy of the GNU Library General Public
*  License along with this library; if not, write to the Free
*  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*  Contact to the authors:
*
*  electronic mail: {bode,stellner}@informatik.tu-muenchen.de
*
*  paper mail:      Prof. Dr. A. Bode
*                   Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                   Institut f"ur Informatik
*                   Technische Universit"at M"unchen
*                   80290 M"unchen
*                   Germany
*
******************************************************************************/
/******************************************************************************

  log.c,v
  1995/11/07 13:51:36
  1.5
  Exp
  stellner

  Authors: G. Stellner

  Description: Routines used to log things which have to be set up upon restart

******************************************************************************/
static char rcs_id[] = "log.c,v 1.5 1995/11/07 13:51:36 stellner Exp";

#include <stdio.h>
#include <stdlib.h>

#include "kojakmalloc.h"
#include "types.h"
#include "error.h"

static Notification *NotificationTable = NULL;

static Notification *GetNotifiEntry()
{
  Notification *p;

  p = (Notification *)TMALLOC(1, Notification, "NOTIFY");

  if ( p == (Notification *)0)  /* did we get memory for it */
    return(NULL);

  p->otids = NULL;
  p->next = NULL;
  p->what = 0;

  return(p);
}


int _LogNotification(what, code, count, otids)
int what;
int code;
int count;
int *otids;
{
  int i;
  Notification *p = NotificationTable;

  if (p == (Notification *)0)   /* any entries present */
  {                             /* no, then try to get memory for table */
    NotificationTable = p = GetNotifiEntry();

    if (p == NULL)              /* did we get the empty slot */
    {
      _Error(WARN, "_LogNotification", _LOC_, "no memory for notification");
      return(-1);
    }
  }
  else
  {
    while ((p->next != NULL) && (p->what != what))
      p = p->next;

    if (p->what != what)        /* no such notification */
    {
      p = GetNotifiEntry();       /* get new memory for it */

      if (p == NULL)            /* did we get the empty slot */
      {
        _Error(WARN, "_LogNotification", _LOC_, "no memory for notification");
        return(-1);
      }
    }

    /* here p points to the slot where we insert the log information */
    p->what = what;
    p->code = code;
    p->count = count;

    if (p->otids != NULL)
      FREE(p->otids);

    p->otids = (int *)TMALLOC(count, int, "NOTIFTIDS");

    if (p->otids == NULL)
    {
      _Error(WARN, "_LogNotification", _LOC_, "no memory for notification");
      return(-1);
    }

    memcpy ((char *)p->otids, (char *)otids, count*sizeof(int));
  }

  return(0);
}

void _ReInsNotifications()
{
  int i;
  Notification *p = NotificationTable;

  for (p=NotificationTable; p!=NULL; p=p->next)
  {
    for (i=0; i<p->count; i++)
      p->otids[i] = _Arp(p->otids[i]);

    PVM_notify(p->what, p->code, p->count, p->otids);
    for (i=0; i<p->count; i++)
      p->otids[i] = _Rarp(p->otids[i]);
  }
}
