/******************************************************************************
*
*  Copyright (C) 1995 A. Bode, J. Pruyne and G. Stellner
*
*  This file is part of CoCheck
*
*  CoCheck is free software; you can redistribute it and/or
*  modify it under the terms of the GNU Library General Public
*  License as published by the Free Software Foundation; either
*  version 2 of the License, or (at your option) any later version.
*
*  CoCheck is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*  Library General Public License for more details.
*
*  You should have received a copy of the GNU Library General Public
*  License along with this library; if not, write to the Free
*  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*  Contact to the authors:
*
*  electronic mail: {bode,stellner}@informatik.tu-muenchen.de
*
*  paper mail:      Prof. Dr. A. Bode
*                   Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                   Institut f"ur Informatik
*                   Technische Universit"at M"unchen
*                   80290 M"unchen
*                   Germany
*
******************************************************************************/
/******************************************************************************

  error.c,v
  1995/11/07 13:51:34
  1.2
  Exp
  stellner

  Authors: G. Stellner

  Description: Error Handling related stuff

******************************************************************************/
static char rcs_id[] = "error.c,v 1.2 1995/11/07 13:51:34 stellner Exp";

#include <stdio.h>
#include <stdlib.h>
#include <varargs.h>

#include "kojakmalloc.h"
#include "error.h"

static int DbLevel = 0;

void _Error(va_alist)
va_dcl
{
  int level;
  char *func;
  char *file;
  int line;
  char *form;
  char buf[1024];
  va_list ap;

  va_start(ap);

  level = va_arg(ap, int);
  func = va_arg(ap, char *);
  file = va_arg(ap, char *);
  line = va_arg(ap, int);
  form = va_arg(ap, char *);

  vsprintf(buf, form, ap);
  va_end(ap);

  switch (level)
  {
  case WARN:
    fprintf(stdout, "%s(%s:%d)%s: %s\n", func, file, line, "Warning", buf);
    fflush(stdout);
    break;
  case FAIL:
    fprintf(stdout, "%s(%s:%d)%s: %s\n", func, file, line, "Fatal", buf);
    fflush(stdout);
    exit(1);
    break;
  default:
    fprintf(stdout, "%s(%s:%d)%s: %s\n", func, file, line, "Unknown", buf);
    fflush(stdout);
    break;
  }
}

void _Db(va_alist)
va_dcl
{
  int level;
  char *func;
  char *file;
  int line;
  char *form;
  char buf[1024];
  va_list ap;

  va_start(ap);

  if ((level = va_arg(ap, int)) <= DbLevel)
  {
    func = va_arg(ap, char *);
    file = va_arg(ap, char *);
    line = va_arg(ap, int);
    form = va_arg(ap, char *);

    vsprintf(buf, form, ap);
    fprintf(stdout, "#%d-%s(%s:%d): %s\n", level, func, file, line, buf);
    fflush(stdout);
  }

  va_end(ap);
}

void _SetDbLevel(level)
int level;
{
  if (level < 0 || level > 10)
    _Error(WARN, "_SetDbLevel", __FILE__, __LINE__,
           "%d not allowed, must be O<=level<=9", level);
  else
    DbLevel = level;
}
