/******************************************************************************
*
*  Copyright (C) 1995 A. Bode, J. Pruyne and G. Stellner
*
*  This file is part of CoCheck
*
*  CoCheck is free software; you can redistribute it and/or
*  modify it under the terms of the GNU Library General Public
*  License as published by the Free Software Foundation; either
*  version 2 of the License, or (at your option) any later version.
*
*  CoCheck is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*  Library General Public License for more details.
*
*  You should have received a copy of the GNU Library General Public
*  License along with this library; if not, write to the Free
*  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*  Contact to the authors:
*
*  electronic mail: {bode,stellner}@informatik.tu-muenchen.de
*
*  paper mail:      Prof. Dr. A. Bode
*                   Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                   Institut f"ur Informatik
*                   Technische Universit"at M"unchen
*                   80290 M"unchen
*                   Germany
*
******************************************************************************/
/******************************************************************************

  condor.c,v
  1995/12/18 10:24:33
  1.6
  Exp
  stellner

  Authors: G. Stellner

  Description: Dummy definitions of some condor functions.

******************************************************************************/
static char rcs_id[] = "condor.c,v 1.6 1995/12/18 10:24:33 stellner Exp";
#include <string.h>
#include <stdlib.h>

#ifndef BSD_SIG
#include <signal.h>
#endif

#include "error.h"

#ifdef DEBUG
int _CkptNum = 0;
#endif

static  char    pvm_sock_buf[40];
static  char    pvm_epid_buf[40];

void _DoCkpt()
{
	int		i;
#ifndef BSD_SIG
	sigset_t	sig_mask;
#endif

  _Db(0, "_DoCkpt", _LOC_, "Condor should create a ckpt file for me");

#ifndef BSD_SIG
	sigprocmask(0, 0, &sig_mask);

	for (i = 1; i <= SIGUSR2; i++) {
		if (sigismember(&sig_mask, i)) {
			_Db(0, "DoCkpt", _LOC_, "Signal %d is blocked!!!\n", i);
		}
	}
#endif

  ckpt();

#ifdef DEBUG
  _CkptNum += 1;
#endif

  _Db(0, "_DoCkpt", _LOC_, "Condor DID create a ckpt file for me");
}


user_restore_pre(user_area, area_size)
char	*user_area;
int		area_size;
{
	char	*pvm_sock;
	char	*pvm_epid;
	int		offset = 0;

	pvm_sock = getenv("PVMSOCK");
	if (pvm_sock == 0) {
		user_area[0] = 0;
		offset = 1;
		_Db(0, "user_restore_pre", _LOC_,
			"Warning! PVMSOCK env. var. not set!");
	} else {
		strcpy(&user_area[0], pvm_sock);
		offset = strlen(pvm_sock) + 1;
	}

	pvm_epid = getenv("PVMEPID");
	if (pvm_epid == 0) {
		user_area[offset] = 0;
		_Db(0, "user_restore_pre", _LOC_,
			"Warning! PVMEPID env. var. not set!");
	} else {
		strcpy(&user_area[offset], pvm_epid);
	}

	return 0;
}

user_restore_post(user_area, area_size)
char    *user_area;
int             area_size;
{
        char    *pvm_sock;
        char    *pvm_epid;

        pvm_sock = user_area;
        sprintf(pvm_sock_buf, "PVMSOCK=%s", pvm_sock);
        pvmputenv(pvm_sock_buf);
        _Db(0, "user_restore_post", _LOC_,
                        "PVMSOCK=%s", pvm_sock);

        pvm_epid = &(user_area[strlen(pvm_sock) + 1]);
        sprintf(pvm_epid_buf, "PVMEPID=%s", pvm_epid);
        pvmputenv(pvm_epid_buf);
        _Db(0, "user_restore_post", _LOC_,
                        "PVMEPID=%s", pvm_epid);

        return 0;
}

set_checkpoint_file_name(ckpt_file_name)
char	*ckpt_file_name;
{
	_Db(0, "set_checkpoint_file_name", _LOC_,
			"Setting checkpoint to file %s", ckpt_file_name);
	init_image_with_file_name( ckpt_file_name );
}


set_checkpoint_fd(ckpt_fd)
int	ckpt_fd;
{
	_Db(0, "set_checkpoint_fd", _LOC_,
			"Setting checkpoint to fd %d", ckpt_fd);
	init_image_with_file_descriptor( ckpt_fd );
}
