/******************************************************************************
*
*  Copyright (C) 1995 A. Bode, J. Pruyne and G. Stellner
*
*  This file is part of CoCheck
*
*  CoCheck is free software; you can redistribute it and/or
*  modify it under the terms of the GNU Library General Public
*  License as published by the Free Software Foundation; either
*  version 2 of the License, or (at your option) any later version.
*
*  CoCheck is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*  Library General Public License for more details.
*
*  You should have received a copy of the GNU Library General Public
*  License along with this library; if not, write to the Free
*  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*  Contact to the authors:
*
*  electronic mail: {bode,stellner}@informatik.tu-muenchen.de
*
*  paper mail:      Prof. Dr. A. Bode
*                   Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                   Institut f"ur Informatik
*                   Technische Universit"at M"unchen
*                   80290 M"unchen
*                   Germany
*
******************************************************************************/
/******************************************************************************

  arp.c,v
  1995/11/07 13:51:30
  1.3
  Exp
  stellner

  Authors: G. Stellner

  Description: Routines used for mapping tids

******************************************************************************/
static char rcs_id[] = "arp.c,v 1.3 1995/11/07 13:51:30 stellner Exp";

#include <stdio.h>
#include <stdlib.h>
#include <varargs.h>

#include "pvm3.h"

#include "kojakmalloc.h"
#include "types.h"
#include "error.h"

#ifdef DEBUG
void printMapTable();
#endif

static int MapEntries = 0;
static Tid *MapTable = NULL;

int _Rarp(ctid)
int ctid;
{
  int i;

  for (i=0; i<MapEntries; i++)  /* look at all entries */
    if (MapTable[i].ctid == ctid) /* entry with that current tid? */
      return(MapTable[i].otid); /* yes, return its original tid */

  return(ctid);                 /* no mapping necessary */
}

int _Arp(otid)
int otid;
{
  int i;

  for (i=0; i<MapEntries; i++)  /* look at all entries */
    if (MapTable[i].otid == otid) /* entry with that original tid? */
      return(MapTable[i].ctid); /* yes, return its current tid */

  return(otid);                 /* no mapping necessary */
}

int _RarpIndex(ctid)
int ctid;
{
  int i;

  for (i=0; i<MapEntries; i++)  /* look at all entries */
    if (MapTable[i].ctid == ctid) /* entry with that current tid? */
      return(i);                /* yes, return its index */

  return(i);                 /* not present */
}

int _ArpIndex(otid)
int otid;
{
  int i;

  for (i=0; i<MapEntries; i++)  /* look at all entries */
    if (MapTable[i].otid == otid) /* entry with that original tid? */
      return(i);                /* yes, return its index */

  return(i);                    /* not present */
}

int _UpdateOrInsert(otid, ctid, n)
int *otid;
int *ctid;
int n;
{
  int i;
  int k;

  if (MapTable == (Tid *)0)     /* any entries already in table */
  {                             /* no, then... */
    MapTable = (Tid *)TMALLOC(n, Tid, "MAP"); /* get memory for it */

    if (MapTable == (Tid *)0)   /* could we really get it */
    {                           /* oops, no more memory, return an error */
      _Error(WARN, "_UpdateOrInsert", _LOC_, "no memory for %d tids\n", n);
      return(-1);
    }

    for (i=0; i<n; i++)         /* now we can insert all tids we got */
    {
      MapTable[MapEntries+i].otid = otid[i];
      MapTable[MapEntries+i].ctid = ctid[i];
      _Db(0, "UpdateOrInsert", _LOC_, "First-time mapping: t%x --> t%x",
		  otid[i], ctid[i]);

    }

    MapEntries += n;            /* remember the number of inserted tids */

  }
  else                          /* there were already entries present */
  {
    for (i=0; i<n; i++)
    {
      k = _ArpIndex(otid[i]);  /* get index in mapping table */

      if (k < MapEntries) {      /* really an entry present */
        MapTable[k].ctid = ctid[i]; /* update present entry */
        _Db(0, "UpdateOrInsert", _LOC_, "Updated mapping: t%x --> t%x",
            otid[i], ctid[i]);
      } else                      /* no matching entry, so insert it */
      {
        MapEntries += 1;        /* one entry more */

        MapTable = (Tid *)TREALLOC(MapTable, MapEntries, Tid); /* get mem */

        if (MapTable == (Tid *)0)   /* could we really get it */
        {                           /* oops, no more memory, return an error */
          _Error(WARN, "_UpdateOrInsert", _LOC_, "no memory for %d tids\n", n);
          return(-1);
        }

        MapTable[MapEntries-1].otid = otid[i]; /* put orig. tid at the end */
        MapTable[MapEntries-1].ctid = ctid[i]; /* put current tid at the end */
        _Db(0, "UpdateOrInsert", _LOC_, "New mapping: t%x --> t%x",
		  otid[i], ctid[i]);
      }
    }
  }
  return(n);
}

#ifdef DEBUG
void printMapTable()
{
  int i;

  for (i=0; i<MapEntries; i++)
    _Db(0, "printMapTable", _LOC_, "%d: t%x => t%x", i, MapTable[i].otid,
        MapTable[i].ctid);
}
#endif
