/******************************************************************************
*
*  Copyright (C) 1995 A. Bode, J. Pruyne and G. Stellner
*
*  This file is part of CoCheck
*
*  CoCheck is free software; you can redistribute it and/or
*  modify it under the terms of the GNU Library General Public
*  License as published by the Free Software Foundation; either
*  version 2 of the License, or (at your option) any later version.
*
*  CoCheck is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*  Library General Public License for more details.
*
*  You should have received a copy of the GNU Library General Public
*  License along with this library; if not, write to the Free
*  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*  Contact to the authors:
*
*  electronic mail: {bode,stellner}@informatik.tu-muenchen.de
*
*  paper mail:      Prof. Dr. A. Bode
*                   Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                   Institut f"ur Informatik
*                   Technische Universit"at M"unchen
*                   80290 M"unchen
*                   Germany
*
******************************************************************************/
/******************************************************************************

  api.c,v
  1995/11/07 13:51:29
  1.2
  Exp
  stellner

  Authors: G. Stellner

  Description: The api functions of CoCheck

******************************************************************************/
static char rcs_id[] = "api.c,v 1.2 1995/11/07 13:51:29 stellner Exp";

#include <stdio.h>
#include <stdlib.h>
#include <pvm3.h>

#include "CoCheckExport.h"

extern int pvmschedtid;

int CoCheckMig(n, migrate, m, dest, metoo)
int n;
int *migrate;
int m;
int *dest;
int metoo;
{
  int tid;
  int zero = 0;
  int method = CoCheckMigr;
  static char file[] = "/tmp/t";

  if ((tid = pvm_mytid()) < 0)
    return(CoCheckNoPvm);

  if (pvmschedtid <= 0)
    return(CoCheckNoRm);

  if (n <= 0)
    return(CoCheckNoMigObs);

  if (metoo)                    /* is caller part of application */
    tid = PvmNoTask;            /* this task should not be excluded then */

  pvm_initsend(PvmDataDefault);
  pvm_pkstr(file);              /* name of the master ckpt file */
  pvm_pkint(&method, 1, 1);     /* the checkpointing method requested */
  pvm_pkint(&tid, 1, 1);        /* task to exclude from application */
  pvm_pkint(&n, 1, 1);          /* number of tasks to migrate */
  pvm_pkint(migrate, 1, 1);     /* task list */
  pvm_pkint(&zero, 1, 1);       /* no machines to vacate */
                                /* no machine list to pack */
  pvm_send(pvmschedtid, CO_CHECK_REQ);

  /* XXX, here we might wait for an ack from the RM and return an appropriate
   * error code
   */
  return(PvmOk);
}

int CoCheckCkpt(ckptfile, metoo, method)
char *ckptfile;
int metoo;
int method;
{
  int tid;
  int zero = 0;

  if ((tid = pvm_mytid()) < 0)
    return(CoCheckNoPvm);

  if (pvmschedtid <= 0)
    return(CoCheckNoRm);

  if (metoo)                    /* is caller part of application */
    tid = PvmNoTask;            /* this task should not be excluded then */

  pvm_initsend(PvmDataDefault);
  pvm_pkstr(ckptfile);          /* name of the master ckpt file */
  pvm_pkint(&method, 1, 1);     /* the checkpointing method requested */
  pvm_pkint(&tid, 1, 1);        /* don't include this task in the ckpt */
  pvm_pkint(&zero, 1, 1);       /* no tasks to migrate */
                                /* no task list to pack */
  pvm_pkint(&zero, 1, 1);       /* no machines to vacate */
                                /* no machine list to pack */
  pvm_send(pvmschedtid, CO_CHECK_REQ);

  /* XXX, here we might wait for an ack from the RM and return an appropriate
   * error code
   */
  return(PvmOk);
}

int CoCheckRst(ckptfile)
char *ckptfile;
{
  int tid;
  int method = CoCheckPort;

  if ((tid = pvm_mytid()) < 0)
    return(CoCheckNoPvm);

  if (pvmschedtid <= 0)
    return(CoCheckNoRm);

  pvm_initsend(PvmDataDefault);
  pvm_pkstr(ckptfile);          /* name of the master ckpt file */
  pvm_pkint(&tid, 1, 1);        /* don't include this task in the ckpt */
  pvm_send(pvmschedtid, CO_CHECK_RESTART);

  /* XXX, here we might wait for an ack from the RM and return an appropriate
   * error code
   */
  return(PvmOk);
}

int CoCheckMove(ckptfile, l, migrate, n, vacate, m, dest, metoo, method)
char *ckptfile;
int l;
int *migrate;
int n;
int *vacate;
int m;
int *dest;
int metoo;
int method;
{
  int tid;

  if ((tid = pvm_mytid()) < 0)
    return(CoCheckNoPvm);

  if (pvmschedtid <= 0)
    return(CoCheckNoRm);

  if ((l <= 0) && (n <= 0))
    return(CoCheckNoMigObs);

  if (metoo)                    /* is caller part of application */
    tid = PvmNoTask;            /* this task should not be excluded then */

  pvm_initsend(PvmDataDefault);
  pvm_pkstr(ckptfile);          /* name of the master ckpt file */
  pvm_pkint(&method, 1, 1);     /* the checkpointing method requested */
  pvm_pkint(&tid, 1, 1);        /* task to exclude from application */
  pvm_pkint(&l, 1, 1);          /* number of tasks to migrate */
  if(l > 0)
    pvm_pkint(migrate, 1, 1);   /* task list */
  pvm_pkint(&n, 1, 1);          /* machines to vacate */
  if (n > 0)
    pvm_pkint(vacate, n, 1);    /* list of machines */
  pvm_send(pvmschedtid, CO_CHECK_REQ);

  /* XXX, here we might wait for an ack from the RM and return an appropriate
   * error code
   */
  return(PvmOk);
}
