/******************************************************************************
*
*  Copyright (C) 1995 A. Bode, J. Pruyne and G. Stellner
*
*  This file is part of CoCheck
*
*  CoCheck is free software; you can redistribute it and/or
*  modify it under the terms of the GNU Library General Public
*  License as published by the Free Software Foundation; either
*  version 2 of the License, or (at your option) any later version.
*
*  CoCheck is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*  Library General Public License for more details.
*
*  You should have received a copy of the GNU Library General Public
*  License along with this library; if not, write to the Free
*  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*  Contact to the authors:
*
*  electronic mail: {bode,stellner}@informatik.tu-muenchen.de
*
*  paper mail:      Prof. Dr. A. Bode
*                   Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                   Institut f"ur Informatik
*                   Technische Universit"at M"unchen
*                   80290 M"unchen
*                   Germany
*
******************************************************************************/
/******************************************************************************

  pvm_rm_ckpt.c,v
  1995/11/07 13:51:05
  1.2
  Exp
  stellner

  Authors: J. Pruyne, G. Stellner

  Description: Checkpointing related functions of the vanilla RM of CoCheck

******************************************************************************/
static char rcs_id[] = "pvm_rm_ckpt.c,v 1.2 1995/11/07 13:51:05 stellner Exp";

#include <stdio.h>
#include <string.h>

char *
read_ckpt_line(FILE *ckpt)
{
	static char	buffer[1024];

	for (;;) {
		fgets(buffer, sizeof(buffer), ckpt);
		if (buffer[0] != '#') {
			break;
		}
	}
	buffer[strlen(buffer) - 1] = '\0';  /* Drop the trailing '\n' */
	return buffer;
}


void
write_ckpt_comment(FILE *ckpt, char *msg)
{
	fprintf(ckpt, "# %s\n", msg);
}


#if 0
int
pvm_rm_write_ckpt(ckpt_file_name)
char	*ckpt_file_name;
{
	FILE	*ckpt_file;

	ckpt_file = fopen(ckpt_file_name, "w");
	if (ckpt_file == NULL) {
		fprintf(stderr, "Failed to open ckpt file %s\n", ckpt_file_name);
		return -1;
	}
	write_ckpt_comment(ckpt_file, "Start of CoCheck master checkpoint file");
	ckpt_host_list(ckpt_file);
	ckpt_task_list(ckpt_file);
	write_ckpt_comment(ckpt_file, "End of CoCheck master checkpoint file");
}


int
pvm_rm_restart_from_ckpt(ckpt_file_name)
char	*ckpt_file_name;
{
	FILE	*ckpt_file;

	ckpt_file = fopen(ckpt_file_name, "r");
	if (ckpt_file == NULL) {
		fprintf(stderr, "Failed to open ckpt file %s\n", ckpt_file_name);
		return -1;
	}
	if (restore_host_list(ckpt_file) < 0) {
		return -1;
	}
	if (restore_task_list(ckpt_file) < 0) {
		return -1;
	}
}

#endif
