/******************************************************************************
*
*  Copyright (C) 1995 A. Bode, J. Pruyne and G. Stellner
*
*  This file is part of CoCheck
*
*  CoCheck is free software; you can redistribute it and/or
*  modify it under the terms of the GNU Library General Public
*  License as published by the Free Software Foundation; either
*  version 2 of the License, or (at your option) any later version.
*
*  CoCheck is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*  Library General Public License for more details.
*
*  You should have received a copy of the GNU Library General Public
*  License along with this library; if not, write to the Free
*  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*  Contact to the authors:
*
*  electronic mail: {bode,stellner}@informatik.tu-muenchen.de
*
*  paper mail:      Prof. Dr. A. Bode
*                   Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                   Institut f"ur Informatik
*                   Technische Universit"at M"unchen
*                   80290 M"unchen
*                   Germany
*
******************************************************************************/
/******************************************************************************

  pvm_rm.c,v
  1995/11/07 13:51:03
  1.5
  Exp
  stellner

  Authors: J. Pruyne, G. Stellner

  Description: Main loop of the vanilla RM of CoCheck

******************************************************************************/
static char rcs_id[] = "pvm_rm.c,v 1.5 1995/11/07 13:51:03 stellner Exp";

#include <stdio.h>
#include <sys/time.h>
#include "pvm3.h"
#include "pvmsdpro.h"

#if defined(CO_CHECK)
#include "CoCheckExport.h"
#endif

int MyTid;
struct pvmhostinfo *local_host;

extern int sm_spawn();
extern int sm_exec();
extern int sm_execack();
extern int sm_task();
extern int sm_config();
extern int sm_addhost();
extern int sm_delhost();
extern int sm_add();
extern int sm_addack();
extern int sm_notify();
extern int sm_taskx();
extern int sm_hostx();
extern int sm_handoff();
extern int sm_sched();
extern int sm_sthost();
extern int sm_sthostack();
#if defined(CO_CHECK)
extern int co_check();
extern int co_check_restart();
extern int co_check_exec_name();
#endif

struct {
	char	*msg_nam;
	int		msg_tag;
	int		(*handler)();
} MsgNames[] = {
{ "SM_SPAWN",	SM_SPAWN, 	sm_spawn	},
{ "SM_EXEC",	SM_EXEC, 	sm_exec		},
{ "SM_EXECACK",	SM_EXECACK, sm_execack	},
{ "SM_TASK",	SM_TASK, 	sm_task		},
{ "SM_CONFIG",	SM_CONFIG, 	sm_config	},
{ "SM_ADDHOST",	SM_ADDHOST,	sm_addhost 	},
{ "SM_DELHOST",	SM_DELHOST,	sm_delhost 	},
{ "SM_ADD",	 	SM_ADD,		sm_add		},
{ "SM_ADDACK",	SM_ADDACK, 	sm_addack	},
{ "SM_NOTIFY",	SM_NOTIFY, 	sm_notify	},
{ "SM_TASKX",	SM_TASKX, 	sm_taskx	},
{ "SM_HOSTX",	SM_HOSTX,	sm_hostx	},
{ "SM_HANDOFF",	SM_HANDOFF,	sm_handoff	},
{ "SM_SCHED",	SM_SCHED,	sm_sched	},
{ "SM_STHOST",	SM_STHOST,	sm_sthost	},
#if defined(CO_CHECK)
{ "CO_CHECK_REQ", CO_CHECK_REQ, co_check },
{ "CO_CHECK_RESTART", CO_CHECK_RESTART, co_check_restart },
{ "CO_CHECK_EXEC_NAME", CO_CHECK_EXEC_NAME, co_check_exec_name },
#endif
{ "SM_STHOSTACK", SM_STHOSTACK, sm_sthostack }
};

main(argc, argv)
int		argc;
char	*argv[];

{
	int		info;
	int		rbuf;
	int		msgtag;
	int		msgtid;
	int		handled_it = 0;
	int		req_id;
	int		i;
	int		nhost;
	int		narch;
	int		ntask;
	struct pvmhostinfo *hosts;
	struct pvmtaskinfo *tasks;
	struct timeval	tmout;

	MyTid = pvm_mytid();

	if (MyTid < 0) {
		argv[0] = "pvmd3";
		info = pvm_start_pvmd(argc, argv, 1);
		MyTid = pvm_mytid();
		if (info < 0 || MyTid < 0) {
			fprintf(stderr, "Unable to initialize PVM :(\n");
			exit(1);
		}
	}

	if (pvm_reg_rm(&local_host) != PvmOk) {
		fprintf(stderr, "Unable to register as RM :(\n");
		exit(1);
	}

	/* Put our host into the host list */
	new_host(local_host);

	/* Get all the other hosts PVM knows about */
	pvm_config(&nhost, &narch, &hosts);
	for (i = 0; i < nhost; i++) {
		new_host(&(hosts[i]));
	}

	/* Put all the tasks except ourself into the task list */
	pvm_tasks(0, &ntask, &tasks);
	for (i = 0; i < ntask; i++) {
		if (tasks[i].ti_tid != MyTid) {
			new_task(&(tasks[i]), "");
		}
	}

	pvm_setopt(PvmResvTids, 1);		/* We want to send directly to pvmd's */

	for(;;) {
		printf("pvm-rm> "); fflush(stdout);

		handled_it = 0;
		rbuf = pvm_recv(-1, -1);

		pvm_bufinfo(rbuf, 0, &msgtag, &msgtid);

		req_id = pvm_getmwid(rbuf);

		for (i = 0; i < sizeof(MsgNames) / sizeof(MsgNames[0]); i++) {
			if (msgtag == MsgNames[i].msg_tag) {
				printf( "\nPVMd message is %s from t%x\n",
						MsgNames[i].msg_nam, msgtid );
				MsgNames[i].handler(msgtid, req_id);
				handled_it = 1;
				break;
			}
		}
		if (handled_it == 0) {
			printf("Unexpected message with tag %d from t%x\n",
				   msgtag, msgtid );
		}
	}
}

