/******************************************************************************
*
*  Copyright (C) 1995 A. Bode, J. Pruyne and G. Stellner
*
*  This file is part of CoCheck
*
*  CoCheck is free software; you can redistribute it and/or
*  modify it under the terms of the GNU Library General Public
*  License as published by the Free Software Foundation; either
*  version 2 of the License, or (at your option) any later version.
*
*  CoCheck is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*  Library General Public License for more details.
*
*  You should have received a copy of the GNU Library General Public
*  License along with this library; if not, write to the Free
*  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*  Contact to the authors:
*
*  electronic mail: {bode,stellner}@informatik.tu-muenchen.de
*
*  paper mail:      Prof. Dr. A. Bode
*                   Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                   Institut f"ur Informatik
*                   Technische Universit"at M"unchen
*                   80290 M"unchen
*                   Germany
*
******************************************************************************/
/******************************************************************************

  kojakmalloc.h,v
  1995/11/07 13:50:46
  1.2
  Exp
  stellner

  Authors: G. Stellner

  Description: Header file to debug malloc calls

******************************************************************************/
/* rcs_id: "kojakmalloc.h,v 1.2 1995/11/07 13:50:46 stellner Exp" */

#ifndef _KOJAKMALLOC
#define _KOJAKMALLOC

#include <malloc.h>

#ifdef DEBUGMALLOC
#define TMALLOC(n, t, c) i_malloc((n)*sizeof(t),(c))
#define TREALLOC(p, n, t) i_realloc(p, (n)*sizeof(t))
#define FREE(p) i_free((char *)p)
#else
#define TMALLOC(n, t, c) malloc((n)*sizeof(t))
#define TREALLOC(p, n, t) realloc(p, (n)*sizeof(t))
#define FREE(p) free((char *)p)
#endif /* DEBUGMALLOC */

#endif /* _KOJAKMALLOC */




