/******************************************************************************
*
*  Copyright (C) 1995 A. Bode, J. Pruyne and G. Stellner
*
*  This file is part of CoCheck
*
*  CoCheck is free software; you can redistribute it and/or
*  modify it under the terms of the GNU Library General Public
*  License as published by the Free Software Foundation; either
*  version 2 of the License, or (at your option) any later version.
*
*  CoCheck is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
*  Library General Public License for more details.
*
*  You should have received a copy of the GNU Library General Public
*  License along with this library; if not, write to the Free
*  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*
*  Contact to the authors:
*
*  electronic mail: {bode,stellner}@informatik.tu-muenchen.de
*
*  paper mail:      Prof. Dr. A. Bode
*                   Lehrstuhl f"ur Rechnertechnik und Rechnerorganisation
*                   Institut f"ur Informatik
*                   Technische Universit"at M"unchen
*                   80290 M"unchen
*                   Germany
*
******************************************************************************/
/******************************************************************************

  CoCheckExport.h,v
  1995/11/07 13:50:42
  1.8
  Exp
  stellner

  Authors: G. Stellner

  Description: Header file containing definitions which are necessary to
               interface with the RM.

******************************************************************************/
/* rcs_id: "CoCheckExport.h,v 1.8 1995/11/07 13:50:42 stellner Exp" */

#ifndef _KOJAKEXPORT
#define _KOJAKEXPORT

#define SM_LAST_CO_CHECK 1234            /* use original PVM value later XXX */

#define CO_CHECK_BASE (SM_LAST_CO_CHECK + 1)
#define CO_CHECK_REQ  (CO_CHECK_BASE + 1)
/*
   Sent to RM to restart from an existing ckpt file
   Message contents:
   char		*checkpoint_file;	: File to retrieve ckpt info. from.
*/

#define CO_CHECK_SYN  (CO_CHECK_BASE + 2)
/*
   Sent by RM to all tasks to begin checkpoint protocol
   Message contents:
   int	chkpt_tid;	 : tid of task initiating checkpoint
   int  chkpt_method : Where to write checkpoint (none, port, file)
   char *ckpt_file   : File to write checkpoint to (only if method is file)
   int	count;		 : Number of tasks in checkpoint protocol
   int	tids[count]; : List of other tasks to synchronize with
*/

#define CO_CHECK_METHOD_FILE	1
#define CO_CHECK_METHOD_PORT	2
#define CO_CHECK_METHOD_NONE	3
#define CO_CHECK_METHOD_MIGR  4

#define CO_CHECK_RDY  (CO_CHECK_BASE + 3)
/*
   Sent by all tasks to checkpointing task.
   Message contents:
    <empty>
*/

#define CO_CHECK_RJN  (CO_CHECK_BASE + 4)
/*
   ??????
   Message contents:
   int	otid;		: original tid
   int	ctid;		: current tid
*/

#define CO_CHECK_LST  (CO_CHECK_BASE + 5)
/*
   Update the tid mapping table
   Message contents:
   int	count;		: number of entires
   int  otids[count] : original tid list
   int  ntids[count] : new tid list
*/

#define CO_CHECK_RESTART	(CO_CHECK_BASE + 6)
/*
   Request a restart
   Message contents:
   char	*ckpt_file;	   : Top level checkpoint file to restart from
*/

#define CO_CHECK_EXEC_NAME	(CO_CHECK_BASE + 7)
/*
   Report binary name to the Resource Manager
   Message contents:
   char		*exec_name;	: Executable name
*/

#define CO_CHECK_PRT	(CO_CHECK_BASE + 8)
/*
   Report port created for migration to the RM
   Message contents:
   bytes	ip_addr[4]	: My IP address (network byte order)
   bytes	port_no[2]	: Port number (network byte order)
*/
#define CO_CHECK_SIG  SIGWINCH

/*
   Error codes returned from CoCheck api
*/
#define CoCheckNoPvm    -2
#define CoCheckNoRm     -3
#define CoCheckNoMigObs -4

/*
   Valid values for the method to be applied
*/
#define CoCheckPort CO_CHECK_METHOD_PORT
#define CoCheckFile CO_CHECK_METHOD_FILE
#define CoCheckMigr CO_CHECK_METHOD_MIGR

#endif /* _KOJAKEXPORT */
