/* @TITLE "update - update version of a pattern file"" */
/*
 * update.c - Copies a pattern file; this will read any old format version
 * and output in current version. Uses any number of procs that are
 * available.
 *
 * David Kotz 6/90,8/90
 */

static char rcsid[] = "$Id: update.c,v 7.1 91/05/09 19:33:24 dfk Tape2 $"; 

#include <stdio.h>
#include <usdfk.h>
#include "format.h"
#include "refs.h"
#include "pat-intern.h"

/* @SUBTITLE "Declarations" */

/* IMPORTED Data */
extern REFS *my_refs;

/* GLOBAL DATA */
static char filename[P_FILENAMELEN+1];	/* first filename */
static char newfilename[P_FILENAMELEN+1]; /* new pattern filename */

/* LOCAL FUNCTIONS */
static void ReadInfo();

/* @SUBTITLE "main program" */
main(argc, argv)
	int argc;
	char **argv;
{
    P_HEAD head;			/* header for pattern file */

    InitializeUs();			/* so we can use parallelism, if there */

    ReadInfo(argc, argv);	/* read pattern parameters */

    if (!LoadPatternShared(filename, &head)) { /* open the first file */
	   fprintf(stderr, "Cannot load pattern '%s'\n", filename);
	   exit(1);
    }

    CreateFile(newfilename, &head);

    /* write the patterns to the file */
    WritePattern();
    /* close file everywhere */
    ClosePattern();

    printf("File %s complete (version %d)\n", 
		 newfilename, PATTERN_FORMAT_VERSION);

    exit(0);
}


/* @SUBTITLE "ReadInfo: Read in the various pattern parameters" */

static void
ReadInfo(argc, argv)
	int argc;
	char **argv;
{
    char line[11];

    if (--argc > 0) {
	   strncpy(filename, *++argv, P_FILENAMELEN);
	   printf("Filename of EXISTING pattern is '%s'\n", filename);
    } else {
	   printf("Name of EXISTING pattern FILE (%d chars): ", P_FILENAMELEN);
	   ReadString(filename, "Filename", P_FILENAMELEN);
    }	   
    if (*filename == '\0') {
	   printf("Must specify filename\n");
	   exit(1);
    }

    if (--argc > 0) {
	   strncpy(newfilename, *++argv, P_FILENAMELEN);
	   printf("Filename of NEW pattern is '%s'\n", newfilename);
    } else {
	   printf("Name of NEW pattern FILE (%d chars): ", P_FILENAMELEN);
	   ReadString(newfilename, "Filename", P_FILENAMELEN);
    }	   
    if (*newfilename == '\0') {
	   printf("Must specify filename\n");
	   exit(1);
    }

    if (access(newfilename, 0) == 0) {
	   printf("File '%s' exists. Overwrite [y]? ", newfilename);
	   ReadString(line, "yes or no", 10);
	   switch (*line) {
		  case 'y':
		  case 'Y':
		  case '\0': {
			 break;
		  }
		  case 'n':
		  case 'N':
		  default: {
			 printf("File not touched.\n");
			 exit(0);
		  }
	   }
    }
}
