/* @TITLE "printpat - print a pattern file" */
/*
 * printpat.c - an interface to the reference printing routines.
 *   Uses the pattern reading routines to read the pattern file.
 *
 * David Kotz 4/89
 */

static char rcsid[] = "$Id: printpat.c,v 7.1 91/05/09 19:33:24 dfk Tape2 $"; 

#include <stdio.h>
#include <usdfk.h>
#include "format.h"
#include "refs.h"
#include "pat-intern.h"

char usage[] = "usage: printpat [-v|-h] <patternfile>\n";

/* see pat-intern.h */
#define NUM_STYLES 11
char style_names[][5] = {
    "RND", "LPR", "LPS", "LW", "GPR", "GPS", "GW", "SEG", "LW1", "MIX", "GRND"
};

static char *StyleName();


/* @SUBTITLE "main program" */
main(argc, argv)
	int argc;
	char **argv;
{
    P_HEAD *head;
    char *filename;
    int nprocs;
    int proc;
    boolean verbose = FALSE;
    boolean header_only = FALSE;

    SetUsConfig(configProcs, 1);
    InitializeUs();

    argc--; argv++;
    if (argc == 0) {
	   fprintf(stderr, usage);
	   exit(1);
    }

    /* -v flag turns on verbose output */
    if (strcmp(*argv, "-v") == 0) {
	   verbose = TRUE;
	   argc--; argv++;
    }

    /* -h flag prints header only */
    if (strcmp(*argv, "-h") == 0) {
	   header_only = TRUE;
	   argc--; argv++;
    }

    if (argc != 1) {
	   fprintf(stderr, usage);
	   exit(1);
    }

    filename = *argv;

    printf("Filename: %s\n", filename);

    if ((head = OpenPattern(filename, "r")) == (P_HEAD *)NULL) {
	   fprintf(stderr, "Cannot open pattern file '%s'\n", filename);
	   exit(1);
    }

    printf("Comment: \n%s\n", head->comment);
    printf("File size: %u bytes\n", head->filesize);
    printf("Max Chunk size: %u bytes\n", head->chunksize);
    printf("References are %s\n", head->writes ? "Writes" : "Reads");
    printf("%s pattern (%s)\n",
		 head->global ? "Global" : "Local", StyleName(head->style));
    if (!head->global)
	 printf("Number of processors: %d\n", head->nprocs);
    if (head->style != PAT_MIX)
	 printf("Computation: %u msec, %s\n", head->computation,
		   head->computation_fixed ? "Fixed" : "Average");
    else
	 printf("Computation: unknown\n");
    printf("\n");

    if (!header_only) {
	   nprocs = head->nprocs;
	   for (proc = 0; proc < nprocs; proc++) {
		  ReadPattern(proc);
		  PrintOneRef(proc, verbose);
	   }
    }

    ClosePattern();

    exit(0);
}

/* @SUBTITLE "StyleName: return the name of the pattern style" */
static char *
StyleName(style)
	int style;
{
    char name[100];

    if (style >= 0 && style < NUM_STYLES)
	 return(style_names[style]);
    else {
	   sprintf(name, "(number %d)", style);
	   return(name);
    }
}
