/* @TITLE "pat-intern.h" */
/* pat-intern.h: Definitions common to all pattern stuff */
/* $Id: pat-intern.h,v 7.1 91/05/09 19:33:24 dfk Tape2 $ */

/* Pattern style codes */
#define PAT_RND 0
#define PAT_LPR 1
#define PAT_LPS 2
#define PAT_LW  3
#define PAT_GPR 4
#define PAT_GPS 5
#define PAT_GW  6
#define PAT_SEG 7
#define PAT_LW1 8
#define PAT_MIX 9			/* a mixture of two patterns */
#define PAT_GRND 10
/* if these are changed or extended, change style_names[] in printpat.c */

/* opening file */
extern void PatternFileInUse();
extern void OpenPatternFile();
extern void ClosePatternFile();
extern boolean SamePatternFile();

/* writing patterns */
extern void CreateFile();	/* create the file and write header */
extern void WritePattern();	/* write all strings to file */

/* reading and updating patterns */
extern boolean LoadPattern();	/* load the pattern completely */
extern boolean LoadPatternShared(); /* load the pattern shared */
extern P_HEAD *OpenPattern();	/* just open and get header */
extern void ReadPattern();	/* read one string of pattern */
extern void UsePattern();	/* use one string of pattern as my_refs */
extern void SetPattern();	/* record one string of pattern */
extern boolean IsSharedPattern();	/* is the current pattern shared? */
extern boolean MakePatternShared(); /* create a new pattern, shared */
extern void RewriteHead();	/* update pattern header */
extern void RewritePattern();	/* update one string of pattern */
extern void ResetPattern();	/* reset pointers in pattern */
extern void ClosePattern();	/* close the pattern */

/* reading from terminal */
extern void ReadString();
extern void ReadNumber();

extern REFS *my_refs;		/* reference string for this proc */
extern int pat_procs;		/* how many procs in this pattern? */
extern FILE *pattern_fp;		/* the current open pattern file */
