/* @TITLE "makewrite - generate write pattern from plain pattern" */
/*
 * makewrite.c - Builds a pattern file to be used by the driver, 
 * based on another pattern file, but using writes instead of reads.
 * WORK IS DONE IN PLACE.
 *
 * In the local case, the work may be done in parallel (using any
 * available processors); in the global case,
 * the work is done only on the main processor and the reference string
 * is shared. The file itself may be written in parallel.
 *
 * David Kotz 11/90
 */

static char rcsid[] = "$Id: makewrite.c,v 7.1 91/05/09 19:33:24 dfk Tape2 $"; 

#include <stdio.h>
#include <usdfk.h>
#include "format.h"
#include "refs.h"
#include "pat-intern.h"
#include "gen.h"

/* @SUBTITLE "Declarations" */

/* GLOBAL DATA */
char filename[P_FILENAMELEN+1];	/* filename */

/* LOCAL FUNCTIONS */
static void ChangeToWrites();
static void ReadInfo();

/* @SUBTITLE "main program" */
main(argc, argv)
	int argc;
	char **argv;
{
    P_HEAD *head;			/* header for file */

    InitializeUs();			/* so we can use parallelism, if there */

    ReadInfo(argc, argv);	/* read pattern parameters */

    head = OpenPattern(filename, "r+"); /* open the file */
    if (head == (P_HEAD *)NULL)
	 exit(1);

    /* We use GenOnI so we can use any processors we have */
    GenOnI(ChangeToWrites, head->nprocs);

    head->writes = TRUE;
    RewriteHead(head);

    /* close file everywhere */
    ClosePattern();

    printf("File %s complete\n", filename);
}

/* @SUBTITLE "ChangeToWrites: change pattern from read to write" */
static void
ChangeToWrites(dummy, p)
	int dummy; 
	int p;				/* which pattern to do? */
{
    int s;				/* chunk number */
    int chunks;			/* total number of chunks */

    ReadPattern(p);			/* read pattern p */
    
    chunks = my_refs->nchunks;

    for (s = 0; s < chunks; s++)
	 my_refs->chunks[s].write = TRUE;
    
    RewritePattern();		/* write it back */
}

/* @SUBTITLE "ReadInfo: Read in the various pattern parameters" */

#define STYLE_LEN 10

static void
ReadInfo(argc, argv)
	int argc;
	char **argv;
{
    if (--argc > 0) {
	   strncpy(filename, *++argv, P_FILENAMELEN);
	   printf("Filename is '%s'\n", filename);
    } else {
	   printf("Name of pattern FILE (%d chars): ", P_FILENAMELEN);
	   ReadString(filename, "Filename", P_FILENAMELEN);
    }	   
    if (*filename == '\0') {
	   printf("Must specify filename\n");
	   exit(1);
    }

}

