/* @TITLE "input.c - common input procedures" */
/*
 * input.c- some functions that are used by many pattern programs to read
 * integers and strings from the user.
 *
 */

static char rcsid[] = "$Id: input.c,v 7.1 91/05/09 19:33:24 dfk Tape2 $"; 

#include <stdio.h>
#include <usdfk.h>

/* @SUBTITLE "ReadString: Read a string" */
void
ReadString(s, name, length)
	char *s;
	char *name;
	int length;
{
    int len;
    int c;

    if (fgets(s, length+1, stdin) == (char *)NULL)
	 exit(1);
    len = strlen(s);
    if (s[len-1] != '\n') {
	   printf("%s too long, truncated to '%s'\n", name, s);
	   do {				/* flush input */
		  c = getchar();
	   } while(c != EOF && c != '\n');
    }
    else
	 s[len-1] = '\0';
}

/* @SUBTITLE "ReadNumber: Read a number" */
void
ReadNumber(string, num)
	char *string;
	int *num;
{
    char line[BUFSIZ];

    ReadString(line, string, BUFSIZ);

    if (sscanf(line, "%d", num) != 1 || *num < 0) {
	   printf("Bad %s '%s'\n", string, line);
	   exit(1);
    }
}

