/* @TITLE "genRND: generator for random patterns" */
/* genRND.c: Pattern for testing RAPIDFILEs. This pattern has every process
 * read chunks at random - no local or global pattern. The bodies run
 * until EACH processor has read 'chunks' chunks. This pattern is treated
 * as a local pattern for the reference string. genGRND creates a similar
 * pattern that is global. This makes a difference, for example, to 
 * the transpat program.
 */

static char rcsid[] = "$Id: genRND.c,v 7.1 91/05/09 19:33:24 dfk Tape2 $"; 

#include <stdio.h>
#include <usdfk.h>
#include "format.h"
#include "refs.h"
#include "pat-intern.h"
#include "gen.h"

static void genForProc();

/* @SUBTITLE "genRND, genGRND" */
void
genRND()
{
    generate(FALSE, FALSE, genForProc); /* local pattern, no portions */
}

void
genGRND()
{
    generate(TRUE, FALSE, genForProc); /* global pattern, no portions */
}

static void
genForProc(index)
	int index;			/* not used here */
{
    int s;
    double exponential();
    unsigned int byte;

    for (s=0; s < chunks; s++) {
	   byte =  random() % filesize;
	   byte = (byte / chunksize) * chunksize;
	   AddRef(s, byte, (unsigned) chunksize, writes);
    }

    /* Now add computation time to each chunk */
    genComputation();

    my_refs->portion_limit = FALSE;
    my_refs->cur_portion_end = my_refs->nchunks - 1;
}
