/* @TITLE "gen.h - generator definitions" */
/* gen.h: Definitions to link makepat.c to gen*.c */
/* $Id: gen.h,v 7.1 91/05/09 19:33:24 dfk Tape2 $ */

/* Generator functions; used by driver main() */
extern void generate();		/* build refs strings */
extern void genComputation();	/* add computation to pattern */
extern void genRND();
extern void genLPR();
extern void genLPS();
extern void genLW();
extern void genGPR();
extern void genGPS();
extern void genGW();

extern void AddRef();		/* add a ref to pattern */

/* Pattern parameters */
extern int PortionSkip;		/* dist btw starts of portions (chunks) */
extern int PortionLength;	/* length of portions (chunks) */
extern unsigned int filesize;	/* size of the file in bytes */
extern int nprocs;			/* number of processors used for pattern */
extern int chunks;			/* number of chunks */
extern int computation;		/* computation time per chunk */
extern boolean computation_fixed; /* computation is fixed amount? */
extern int chunksize;		/* size of chunks (bytes) */
extern boolean writes;		/* do writes (T), or reads (F) */

