/* @TITLE "gen.c - general part of pattern generation" */
/* gen.c: Builds a reference string for local or global patterns.
 * In the local case, the work is done in parallel; in the global case,
 * the work is done only on the main processor and the reference string
 * is shared.
 */

static char rcsid[] = "$Id: gen.c,v 7.1 91/05/09 19:33:24 dfk Tape2 $"; 

#include <stdio.h>
#include <usdfk.h>
#include "format.h"
#include "refs.h"
#include "pat-intern.h"
#include "gen.h"

/* GLOBAL variables */
REFS *my_refs;				/* my reference string */

/* LOCAL FUNCTIONS */
static void genOneString();	/* makes one reference string */
static void genFREE();		/* free the reference string. */
static boolean usesportions;
static void (*workerproc)();
static boolean global;

/* @SUBTITLE "generate: General generator" */
void
generate(isglobal, haveportions, worker)
	boolean isglobal;		/* TRUE if a global pattern */
	boolean haveportions;	/* uses portions? */
	void (*worker)();		/* worker to build string */
{
    usesportions = haveportions;
    Share(&usesportions);
    workerproc = worker;
    Share(&workerproc);
    global = isglobal;
    Share(&global);

    GenOnI(genOneString, nprocs);
}

/* @SUBTITLE "genOneString: Make one pattern string" */
/* (parallel for local patterns) */
static void
genOneString(dummy, index)
	int dummy;
	int index;			/* which string in the pattern */
{
    /* Seed random number generator */
    srandom(index * 1000 + GetRtc());

    my_refs = (REFS *) AllocLocal(sizeof(REFS));
    bzero(my_refs, sizeof(REFS));

    my_refs->global = global;

    my_refs->chunks =
	 (ONEREF *) AllocLocal(chunks * sizeof(ONEREF));
    my_refs->nchunks = chunks;
    my_refs->chunksize = chunksize;

    /* Build the string itself */
    (*workerproc)(index);

    SetPattern(index);		/* record my_refs as string #index */
}

/* @SUBTITLE "AddRef: Add a reference to my pattern" */
void
AddRef(chunk, offset, length, write)
	int chunk;			/* chunk number */
	unsigned int offset, length; /* position and length */
	boolean write;			/* read or write */
{
    ONEREF *c = &(my_refs->chunks[chunk]);

    c->offset = offset;
    c->length = length;
    c->write = write;
    c->comptime = 0;
}
