/* @TITLE "format.h - pattern file format" */
/* format.h: Pattern file information, to make reference strings.
 *   Reference strings are now lists of tuples, each representing a 
 * chunk: (read/write flag, offset, length, comptime).
 * Future expansion:
 *    add synch points to pattern for more general synch types
 */

/* $Id: format.h,v 7.1 91/05/09 19:33:24 dfk Tape2 $ */

/* File format: */
/* (char) magic number
 * (char) version number
 * (structure) header
 * (array of string headers) string header for each string
 * (array of strings) each of the strings
 *   each string has format:
 *   (array of references) the set of references in this string
 *   (array of portions) the portions in this string, if any
 * each reference is a ONEREF structure
 */

#define PATTERN_MAGIC 0x25	/* magic number in first word of pattern files */
#define PATTERN_FORMAT_VERSION 1 /* current version of pattern file format */
#define P_NAMELEN 39
#define P_COMLEN 79
#define P_FILENAMELEN 100

/* typedef's used here */
typedef struct pattern_s P_HEAD;
typedef struct string_s P_STRING;

struct pattern_s {
    char name[P_NAMELEN+1];	/* name of pattern */
    char comment[P_COMLEN+1]; /* comment about pattern */
    unsigned int filesize;	/* "file" size in bytes */
    boolean global;			/* global (T) or local (F) pattern */
    int nprocs;			/* number of strings in this file */
    unsigned int chunksize;	/* maximum chunksize in string */
    /* these aren't necessary but tell how it was made */
    boolean writes;			/* all writes (T), or all reads(F)? */
    unsigned int computation;	/* computation per chunk */
    boolean computation_fixed; /* is computation a fixed amount? */
    short style;			/* pattern style (eg PAT_LPS) */
};

/* Where to find the string header for string s, s in [0,nprocs) */
#define STRING_POS(s) ((unsigned int) \
  (2*sizeof(short)+sizeof(P_HEAD)+(s)*sizeof(P_STRING)))

struct string_s {
    unsigned short numrefs;	/* number of references in this string */
    unsigned short numportions; /* number of portions in this string */
    boolean portion_limit;	/* limit prefetching to this portion? */
    unsigned long location;	/* start of refs array in file */
};
