/* @TITLE "extract - extract references from pattern file" */
/*
 * extract.c - Reads a pattern file and prints out references,
 * one processor at a time, with a blank line between processors. 
 * Does not use parallelism.
 *
 * Output is to stdout. Each reference line is
 *    R offset length [comptime]
 * or
 *    W offset length [comptime]
 * The comptime column is only printed if the -c option is given. 
 * Offset and length in bytes, comptime in msec (float).
 *
 * usage: extract [-c] patternfilename
 *
 * David Kotz 1990
 */

static char rcsid[] = "$Id: extract.c,v 7.1 91/05/09 19:33:24 dfk Tape2 $"; 

#include <stdio.h>
#include <usdfk.h>
#include "format.h"
#include "refs.h"
#include "pat-intern.h"

char usage[] = "usage: extract [-c] <patternfile>\n";

/* @SUBTITLE "main program" */
main(argc, argv)
	int argc;
	char **argv;
{
    P_HEAD *head;			/* header for file */
    char *filename;			/* pattern filename */
    int proc;				/* processor number */
    int i;
    ONEREF *ref;
    boolean showcomp;

    if (argc != 2 && argc != 3) {
	   fprintf(stderr, usage);
	   exit(1);
    }
    if (argc == 3 && strcmp(argv[1] == "-c") == 0) {
	   showcomp = TRUE;
	   filename = argv[2];
    } else {
	   showcomp = FALSE;
	   filename = argv[1];
    }

    SetUsConfig(configProcs, 1);
    InitializeUs();			/* we don't use parallelism */

    head = OpenPattern(filename, "r"); /* open the file */
    if (head == (P_HEAD *)NULL)
	 exit(1);

    for (proc = 0; proc < head->nprocs; proc++) {
	   ReadPattern(proc);
	   for (i = 0; i < my_refs->nchunks; i++) {
		  ref = &(my_refs->chunks[i]);
		  if (showcomp)
		    printf("%c %u %u %g\n", 
				 ref->write ? 'W' : 'R', ref->offset, ref->length,
				 ref->comptime / 100.);
		  else
		    printf("%c %u %u\n", 
				 ref->write ? 'W' : 'R', ref->offset, ref->length);

	   }
	   printf("\n");
    }

    /* close file everywhere */
    ClosePattern();

    exit(0);
}

