/* @TITLE "change - change an lpr to have no portion_limit" */
/*
 * change.c - quickie program
 *
 * David Kotz 5/89
 */

static char rcsid[] = "$Id: change.c,v 6.1 91/05/09 19:41:05 dfk Tape2 $"; 

#include <stdio.h>
#include <usdfk.h>
#include "format.h"
#include "refs.h"
#include "pat-intern.h"
#include "gen.h"

/* @SUBTITLE "Declarations" */

/* GLOBAL DATA */
char filename[FILENAMELEN+1];	/* filename */

/* LOCAL FUNCTIONS */
static void ClearLimit();
static void ReadInfo();
static void ReadString();
static void ReadNumber();
static void ShareInfo();

/* @SUBTITLE "main program" */
main(argc, argv)
	int argc;
	char **argv;
{
    P_HEAD *head;			/* header for file */

    InitializeUs();			/* so we can use parallelism, if there */

    ReadInfo(argc, argv);	/* read pattern parameters */

    ShareInfo();			/* share parameters */

    head = OpenPattern(filename, "r+"); /* open the file */
    if (head == (P_HEAD *)NULL)
	 exit(1);

    /* We use GenOnI so we can use any processors we have */
    GenOnI(ClearLimit, head->nprocs);

    /* close file everywhere */
    ClosePattern();

    printf("File %s complete\n", filename);
}

/* @SUBTITLE "ClearLimit: clear portion_limit on a pattern" */
static void
ClearLimit(dummy, p)
	int dummy; 
	int p;				/* which pattern to do? */
{
    P_STRING string;		/* one string header */
    
    OpenPatternFile();

    /* read string header */
    fseek(pattern_fp, STRING_POS(p), 0);
    fread(&string, sizeof(string), 1, pattern_fp);

    string.portion_limit = FALSE;

    fseek(pattern_fp, STRING_POS(p), 0);
    fwrite(&string, sizeof(string), 1, pattern_fp);
}

/* @SUBTITLE "ReadInfo: Read in the various pattern parameters" */

#define STYLE_LEN 10

static void
ReadInfo(argc, argv)
	int argc;
	char **argv;
{
    char style[STYLE_LEN+1];
    char line[11];

    printf("Note: %d Procs in use\n", ProcsInUse());

    if (--argc > 0) {
	   strncpy(filename, *++argv, FILENAMELEN);
	   printf("Filename is '%s'\n", filename);
    } else {
	   printf("Name of pattern FILE (%d chars): ", FILENAMELEN);
	   ReadString(filename, "Filename", FILENAMELEN);
    }	   
    if (*filename == '\0') {
	   printf("Must specify filename\n");
	   exit(1);
    }

}

/* @SUBTITLE "ReadString: Read a string" */
static void
ReadString(s, name, length)
	char *s;
	char *name;
	int length;
{
    int len;
    int c;

    if (fgets(s, length+1, stdin) == (char *)NULL)
	 exit(1);
    len = strlen(s);
    if (s[len-1] != '\n') {
	   printf("%s too long, truncated to '%s'\n", name, s);
	   do {				/* flush input */
		  c = getchar();
	   } while(c != EOF && c != '\n');
    }
    else
	 s[len-1] = '\0';
}

/* @SUBTITLE "ShareInfo: Share the pattern parameters" */
static void
ShareInfo()
{
    ShareBlk(filename, FILENAMELEN+1);
}

