/* @TITLE "interface.c - SIMULATED - simulate the library" */
/* interface.c (SIMULATED)
 * 
 * DESCRIPTION:	RAPID management routines.  These are the subroutines 
 *		invoked by application programs: 
 * 
 *			RT_close 
 *			RT_creat 
 *			RT_flush 
 *			RT_lseek 
 *			RT_open 
 *			RT_read 
 *			RT_write 
 * 
 *             RT_dump 
 *
 * note that the testparm file is hardwired into RT_open to be called
 * "testparm". A way around this is desired. 
 */

/* INCLUDES */

#include <stdio.h>
#include <usdfk.h>
#include "testparm.h"
#include "internal.h"
#include "rapidelog.h"
#include "stats.h"

/* @SUBTITLE "DEFINES" */

/* Diagnostic flags (print diagnostic messages of non-fatal errors) */

#define CLOSE_DIAG_FLAG
#define CREAT_DIAG_FLAG
#define LSEEK_DIAG_FLAG
#define OPEN_DIAG_FLAG
#define READ_DIAG_FLAG
#define	STAT_DIAG_FLAG
#define TRUNC_DIAG_FLAG
#define WRITE_DIAG_FLAG

/* Debugging flags (print messages for debugging aids) */

/* #define CLOSE_DEBUG_FLAG 
 * #define CREAT_DEBUG_FLAG 
 * #define LSEEK_DEBUG_FLAG 
 * #define OPEN_DEBUG_FLAG 
 * #define READ_DEBUG_FLAG 
 * #define STAT_DEBUG_FLAG 
 * #define TRUNC_DEBUG_FLAG 
 * #define WRITE_DEBUG_FLAG 
 */

/* GLOBAL VARIABLES */

static TESTPARM parms;		/* current set of parameters loaded */

static void OpenWorker();

/* @SUBTITLE "RT_close" */
/* ARGSUSED */
void
RT_close (rpd)
    RAPIDFILE    **rpd;
{
}

/* @SUBTITLE "RT_dump" */
/* ARGSUSED */
void
RT_dump (rpd)
	RAPIDFILE *rpd;
{
}

/* @SUBTITLE "RT_flush" */
/* ARGSUSED */
void
RT_flush (rpd)
    RAPIDFILE *rpd;
{
}

/* @SUBTITLE "RT_lseek" */
long
RT_lseek (rpd, offset, whence)
    RAPIDFILE *rpd;
    long    offset;
    int	    whence;
{
    return(0L);
}

/* @SUBTITLE "RT_open" */
/* VARARGS */
void
RT_open ()
	/* actually lots of args but we ignore them */
{
    FILE *fp;				/* file with parameters of this test */
    char *name = "testparms";

    if ((fp = fopen(name, "r")) == (FILE *)NULL) {
	   fprintf(stderr, "Could not open parameter file '%s'\n", name);
	   exit(1);
    }

    fscanf(fp, "%d %d %f %f %d\n",
		 &(parms.filesize), &(parms.readtime),
		 &(parms.missratio), &(parms.hitwait),  &(parms.misswait));

    fclose(fp);

    GenTaskForEachProc(OpenWorker, 0);
}

static void
OpenWorker()
{
    srandom(UsProc_Node*2 +100 + GetRtc());
}

/* @SUBTITLE "RT_read" */
/* ARGSUSED */
unsigned int
RT_read (rpd, buf, nbytes)
	RAPIDFILE    *rpd;
	char    *buf;
	unsigned int nbytes;			/* Note: long for RAPIDFILEs */
{
    TICS start;
    extern double exponential();

    start = GetRtc();

    if (parms.readtime == 0) {
	   if ((random() % 1000) / 1000. <= parms.missratio) { /* miss */
		  ELOG_LOG(RTELOG_DEMAND_FETCH, 0);
		  ELOG_LOG(RTELOG_IDLE, parms.misswait)
		  Sleep(parms.misswait);
		  my_stats->demand++;
	   } else {
		  int wait = exponential(1/parms.hitwait);
		  ELOG_LOG(RTELOG_HIT, 0)
		  ELOG_LOG(RTELOG_IDLE, wait)
		  Sleep(wait);
		  my_stats->bufferhit++;
		  if (wait > 0) {
			 my_stats->hitwait += wait;
			 my_stats->unready++;
		  }
	   }
    } else {
	   ELOG_LOG(RTELOG_DEMAND_FETCH, 0);
	   ELOG_LOG(RTELOG_IDLE, parms.readtime)
	   Sleep(parms.readtime);
	   my_stats->demand++;
    }

    /* Update statistics */
    my_stats->readtime += GetRtc() - start;
    my_stats->nread++;

    return (nbytes);
}

/* @SUBTITLE "RT_write" */
/* ARGSUSED */
unsigned int
RT_write (rpd, buf, nbytes)
	RAPIDFILE *rpd;
	char    *buf;
	unsigned int nbytes;
{
    return (nbytes);
}
