/* @TITLE "stats.c: manage statistics" */
/* stats.c: create statistics structures
 * 
 *            RT_InitStats
 *            RT_ClearStats
 */

static char rcsid[] = "$Id: stats.c,v 7.1 91/05/09 19:31:27 dfk Tape2 $"; 

#include <stdio.h>
#include <usdfk.h>
#include "stats.h"

/* GLOBAL VARIABLES */
STAT *my_stats = NULL;		/* per-processor stat variable */
STAT **RT_stats = NULL;		/* array of processor's my_stats */

/* LOCAL variables */
static short *init_count;	/* used to generate unique index */
static short size_stats;		/* size of the RT_stats array */

/* LOCAL FUNCTIONS */
static void InitWorker();

/* @SUBTITLE "InitStats" */
/* This can be called many times, re-using structures that exist,
 * if any. Always ends up with every in-use processor having a cleared
 * stats array, and their pointers in the first ProcsInUse() locations
 * in RT_stats.
*/
void
RT_InitStats()
{
    AllocateShareZero(init_count, short);

    /* free old stats array if too small */
    if (RT_stats != (STAT **)NULL && size_stats < ProcsInUse()) {
	   UsFree(RT_stats);
	   RT_stats = NULL;
    }

    /* allocate stats array if necessary */
    if (RT_stats == (STAT **) NULL) {
	   /* allocate the shared array */
	   RT_stats = (STAT **) AllocGlobal(ProcsInUse() * sizeof(STAT *));
	   size_stats = ProcsInUse();
    }

    Share(&RT_stats);

    /* now get other processors set up */
    GenTaskForEachProc(InitWorker, 0);

    UsFree(init_count);
}

static void
InitWorker()
{
    if (my_stats == (STAT *)NULL) {
	   /* allocate my stats structure */
	   my_stats = (STAT *)AllocLocal(sizeof(STAT));
	   if (my_stats == (STAT *)NULL) 
		printf("No memory for stats on proc %d\n", UsProc_Node);
    }

    /* erase all stats in my_stats */
    RT_ClearStats();

    /* store my pointer in global array */
    RT_stats[Atomic_add(init_count, 1)] = my_stats;
}

/* @SUBTITLE "RT_ClearStats: reset the statistics for this node" */
void
RT_ClearStats()
{
    if (my_stats != (STAT *)NULL)
	 bzero(my_stats, sizeof(STAT));
}

