/* @TITLE "replace.c - generic replacement strategy - inteace" */
/* replace.c: Support for frame replacement algorithm. 
 *             Choose and initialize an algorithm.
 *			Includes the following: 
 * 
 *			RT_InitReplaceInode() 
 *			RT_InitReplaceRPD() 
 *
 * The rest is done by macros from replace.h that call functions given by 
 * pointers in rpd->replace and inode_ptr->replace. These pointers are 
 * set up through the initialization.
 */

static char rcsid[] = "$Id: replace.c,v 7.1 91/05/09 19:31:27 dfk Tape2 $"; 

/* INCLUDES */

#include <stdio.h>
#include <usdfk.h>
#include "replace.h"
#include "internal.h"

/* Functions called in replace-ws.c */
extern void RT_InitReplaceInode_ws();
extern void RT_InitReplaceRPD_ws();

/* Functions called in replace-toss.c */
extern void RT_InitReplaceInode_toss();
extern void RT_InitReplaceRPD_toss();

/* Local functions */
static void RT_InitReplaceInode_none();
static void RT_InitReplaceRPD_none();

/* @SUBTITLE "RT_InitReplaceInode: initialize replacement scheme" */
void
RT_InitReplaceInode(inode_ptr)
	RAPID_INODE *inode_ptr;
{
    switch (inode_ptr->replace.style) {
	   case RT_REPLACE_NONE: {
		  RT_InitReplaceInode_none(inode_ptr);
		  break;
	   }
	   case RT_REPLACE_WS: {
		  RT_InitReplaceInode_ws(inode_ptr);
		  break;
	   }
	   case RT_REPLACE_TOSS: {
		  RT_InitReplaceInode_toss(inode_ptr);
		  break;
	   }
	   default: {
		  printf("RT_InitReplaceInode: Unknown replacement style %d\n",
			    inode_ptr->replace.style);
	   }
    }
}

/* @SUBTITLE "RT_InitReplaceRPD: initialize replacement - descriptor" */
void
RT_InitReplaceRPD(rpd, data)
	RAPIDFILE *rpd;
	int data;
{
    switch (rpd->replace.style) {
	   case RT_REPLACE_NONE: {
		  RT_InitReplaceRPD_none(rpd);
		  break;
	   }
	   case RT_REPLACE_WS: {
		  RT_InitReplaceRPD_ws(rpd, data);
		  break;
	   }
	   case RT_REPLACE_TOSS: {
		  RT_InitReplaceRPD_toss(rpd, data);
		  break;
	   }
	   default: {
		  printf("RT_InitReplaceRPD: Unknown replacement style %d\n",
			    rpd->replace.style);
	   }
    }
}

/* @SUBTITLE "RT_InitReplace*_none: dummy scheme" */
/* used for non-caching tests  */

/* a no-op function returning void */
static void dummy_void() {}

/* a no-op function returning FALSE */
static boolean dummy_false() { return(FALSE); }

static void
RT_InitReplaceInode_none(inode_ptr)
	RAPID_INODE *inode_ptr;
{
    /* make data structures needed by findframe */
    inode_ptr->replace.private = (ANYPTR)NULL;
    inode_ptr->replace.doneinode = dummy_void;
}

static void
RT_InitReplaceRPD_none(rpd)
	RAPIDFILE *rpd;
{
    rpd->replace.private = (ANYPTR)NULL;

    rpd->replace.donerpd = dummy_void;
    rpd->replace.notifyA = dummy_false;
    rpd->replace.notifyB = dummy_void;
    rpd->replace.findframe = dummy_false;
    rpd->replace.replaceable = dummy_void;
    rpd->replace.dump = dummy_void;
}


