/* @TITLE "binarith.c - binary arithmetic" */
/*
 * binarith.c:	Binary arithmetic support for Rapid system 
 */

static char rcsid[] = "$Id: binarith.c,v 7.1 91/05/09 19:31:27 dfk Tape2 $"; 

/* @SUBTITLE"Binary_log2: compute integer log base 2" */
/*	This routine calculates the (integer) log to the base 2 of the 
 *	supplied integer argument.  It does so by shifting bits to the right 
 *	until only the LSB is still high.  For numbers which are NOT even 
 *	powers of 2, the value returned is the log of the next lower power 
 *	of 2. 
 */

int
Binary_log2 (x)
	long    x;
{
    int	    exp;
    
    exp = 0;
    while (x > 1)	{
	   x = x >> 1;
	   exp++;
    }
    return (exp);
}

/* @SUBTITLE "Next_Larger_Power_of_2: for a given integer" */
/*	This routine returns a number which is the next larger even power of 
 *	above the passed argument.  This is useful in memory allocation 
 *	calculations as it provides the next segment size large enough to 
 *	hold the given object. 
 */

long
Next_Larger_Power_of_2 (x)
	long	x;
{
    long	tmp_x;
    int		exp;
    
    /* Shift out all of the 1s, counting as you go */
    
    tmp_x = x;
    exp = 0;
    while (tmp_x > 0)	{
	   tmp_x = tmp_x >> 1;
	   exp++;
    }
    
    /* If there were some 1 bits to the right of the most significant 1, this 
	* calculation of the exponent was correct, so return the appropriate value. 
	* Otherwise, the passed parameter was an even power of 2 to begin with, in 
	* which case our calculation is one higher than it need be.  So return the 
	* value using (exp - 1). 
	*/
    
    if (((long) 1 << (exp - 1)) -1 & x)
	 return ((long) 1 << exp);
    
    else
	 return ((long) 1 << (exp - 1));
}
