/* @TITLE "usdfk.h - DFK/US include file" */
#include <us.h>
#include "dfk.h"
/* $Id: usdfk.h,v 7.1 91/05/09 19:29:51 dfk Tape2 $ */

/* The Uniform System's representation of a lock */
typedef short lock_t;
/* A lock attempt consistent with UsLock and UsUnlock */
#define TryLock(p) (Atomic_ior((p), 1) == 0)

#define sleep(sec) UsWait((sec)*1000*100)

typedef unsigned long TICS;	/* type for storing rtc values */
#define USECperTICK (62.5)
#define TICKperUSEC (0.016)	/* 1/62.5 */
#define TICKperMSEC (16.)	/* 1000./62.5 */
#define MSECperTICK (0.0625)	/* 62.5/1000. */
#define SECperTICK (6.25e-5)	/* 62.5/1000./1000. */

/* Useful for allocating and sharing simple items */
#define AllocateShare(name, type, value) \
    (name = (type*)UsAlloc(sizeof(type)), \
	*name = (value), \
	Share(&name))

/* Useful for allocating and sharing any items (No initialization) */
#define AllocateShareAny(name, type) \
    (name = (type*)UsAlloc(sizeof(type)), \
	Share(&name))

/* Useful for allocating, zeroing, and sharing any object */
#define AllocateShareZero(name, type) \
    (name = (type*)UsAlloc(sizeof(type)), \
	bzero(name, sizeof(type)), \
	Share(&name))

#define Atomic_add(p,n) ((short) atomadd((short *)(p),(short)(n)))
#define Atomic_and(p,n) ((short) atomand((short *)(p),(short)(n)))
#define Atomic_cta(p,m,i) ((short) atomcta((short *)(p),(short)(m),(short)(i)))
#define Atomic_ior(p,n) ((short) atomior((short *)(p),(short)(n)))
#define Atomic_swap(p,n) ((short) atomcta((short *)(p),(short)0xffff,(short)(n)))
