/* @TITLE "stats.h - statistics" */
/* $Id: stats.h,v 7.1 91/05/09 19:29:51 dfk Tape2 $ */

/* statistics private to each processor */
typedef struct stat_s STAT;
struct stat_s {
    TICS readtime;			/* total read time */
    TICS writetime;		/* total write time */
    unsigned short nread;	/* # of reads */
    unsigned short nwrite;	/* # of writes */
    unsigned short demand;	/* # demand fetches */
    unsigned short bufferhit;	/* # cached sector uses */
    unsigned short unready;	/* number of unready hits & uses */
    TICS hitwait;			/* amount of time waiting for hits */
    TICS notify;			/* time spent in prefetch notify */
    unsigned short reads;	/* total disk reads */
    unsigned short writes;	/* total disk writes */
    unsigned short rereads;	/* sectors read after writeback */
    unsigned short rewrites;	/* sectors written after writeback */

    /* prefetch work done */
    unsigned short prefetch;	/* # sectors prefetched */
    unsigned short prefetch_used; /* # prefetched sectors used */
    unsigned short mistake;	/* # sectors mistakenly predicted */
    unsigned short wasted;	/* # sectors prefetched and not used */
    unsigned short usedmistake; /* # sectors marked for mistake but used */
    unsigned short scanq;	/* # swapouts we waited for read to complete */
    unsigned short correct;	/* # sectors predicted correctly */
    TICS prefetchtime;		/* time spent prefetching */
    unsigned long  prefetchcount; /* number of calls to prefetch */
    unsigned short prefetchdemand;	/* prefetch tries when demand fetching */
    TICS pfdemand_delay;	/* lateness amount */
    unsigned short prefetchbufhit;	/* prefetch tries during buffer hit wait */
    TICS pfbufhit_delay;	/* lateness amount */
};

extern STAT *my_stats;				/* this processor's stats */
extern STAT **RT_stats;				/* array of all my_stats pointers */

extern void RT_InitStats();	/* init/clear statistics for all procs */
extern void RT_ClearStats();	/* clear statistics for this proc */
