/* @TITLE "replace.h - RAPID replacement algorithms" */
/* $Id: replace.h,v 7.1 91/05/09 19:29:51 dfk Tape2 $ */

/* Replacement algorithms from replace.c */
#define RT_REPLACE_NONE 0	/* none --- for non-caching */
#define RT_REPLACE_WS 1		/* working-set */
#define RT_REPLACE_TOSS 2	/* special case of working-set with wss=1 */

/* INTERNAL ONLY: */

typedef struct ffdata_s FFDATA; /* we use pointers only */

/* macros for easy access to replacement functions */
#define RT_DoneReplaceInode(inode_ptr) \
  ((*((inode_ptr)->replace.doneinode))(inode_ptr))
#define RT_DoneReplaceRPD(rpd) \
  ((*((rpd)->replace.donerpd))(rpd))
#define RT_NotifyReplaceA(rpd, sector) \
  ((*((rpd)->replace.notifyA))((rpd),(sector)))
#define RT_NotifyReplaceB(rpd, sector) \
  ((*((rpd)->replace.notifyB))((rpd),(sector)))
#define RT_FindFrame(rpd, sector, sme, prefetching) \
  ((*((rpd)->replace.findframe))((rpd), (sector), (sme), (prefetching)))
#define RT_Replaceable(rpd, sector) \
  ((*((rpd)->replace.replaceable))((rpd), (sector)))
