/* @TITLE "refs.h - reference string structure" */
/* $Id: refs.h,v 7.1 91/05/09 19:29:51 dfk Tape2 $ */

/* refs.h: Reference strings, used by driver and prefetching.  */

/* To avoid including this everywhere, rpd->prefetch.refs is
 * declared as ANYPTR instead of REFS*, but casted to REFS* where
 * needed.
 */

/* One chunk in the reference string */
typedef struct oneref_s ONEREF;

struct oneref_s {
    boolean write;			/* TRUE if write, FALSE if read */
    unsigned int offset;		/* in bytes */
    unsigned int length;		/* in bytes */
    unsigned int comptime;	/* in .01 msec */
};

/* The whole reference string */
/* The *readingchunk pointer deserves special mention. It points to 
 * a location in process-private static data -- and therefore is a pointer
 * valid on all procs pointing to a separate physical location for each
 * proc. It is a location in body.c that is maintained by the Body() when
 * it is running through the refs. It contains the chunk number that is
 * currently in use. It is used by the EXACT predictor to track progress
 * through the reference string, specifically in global patterns.
 */
typedef struct refs_s REFS;

struct refs_s {
    boolean global;			/* global (T) or local (F) pattern */
    ONEREF *chunks;			/* array of references */
    unsigned int *portions;	/* array of indices that are end of portion */
    int nchunks;			/* length of sectors[] */
    int nportions;			/* length of portions[] */
    int next;				/* index of next sector to read */
    int *readingchunk;		/* chunk number in current use */
    int cur_portion_end;		/* index of end of current portion */
    int chunksize;			/* maximum chunksize */
    boolean portion_limit;	/* limit prefetch to current portion? */
};

